<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Settings_Orphaned extends Ext_Web_Component
{
    
    private $list = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('delete', 'doDelete');
        
        $this->setAccessGroup(Ext_Db_User::GROUP_USER);
    }

    /**
     * The default init method
     *
     */
    function init() 
    {
        $offset = intval($this->getRequest()->getParameter($this->getEventKey('offset')));
        $limit = 25;
        $this->list = Ext_Db_PageMapper::findOrphanedPages('`created` DESC', $limit, $offset);
        $this->addChild(Dk_Ui_Pager::makeFromList($this->list));
        
        
        
        
        
        // Get orderby, limit, offset
        $loo = Dk_Util_Loo::createFromRequest($this->getId());
        $list = Ext_Db_PageMapper::findOrphanedPages($loo->getOrderBy(), $loo->getLimit(), $loo->getOffset());
        
        // create table manager
        $cManager = new Dk_Ui_Table_Base($list);
        $this->addChild($cManager);
        
        $cells = array();
        $cells['C'] = 'Dk_Ui_Table_CheckboxCell';
        $cells['pageId'] = 'Ext_Modules_PageIdCell';
        $cells['title'] = Dk_Ui_Table_CellFactory::TYPE_STRING;
        $cells['created'] = 'Dk_Util_DateCell';
        
        $cellArray = Dk_Ui_Table_CellFactory::createCellsFromArray($cells, 'title', new Dk_Util_Url('/index.html'), 'pageId');
        $cManager->setCells($cellArray);
        
        $cManager->addAction(new Dk_Ui_Table_Action($this->getEventKey('delete'), 'Delete Selected', 'delete', 'Do you want to delete these records?'));
    }
    
    
    /**
     * The default event handler.
     * 
     */
    function doDelete() 
    { 
        $page = Ext_Db_PageMapper::find($this->getRequest()->getParameter('delete'));
        
        if ($page) {
            $page->delete();
        }
        
        $url = Dk_Request::getInstance()->getRequestUri();
        $url->removeQueryField('delete');
        $url->redirect();
    }
    
    
    
    /**
     * The default show method.
     *
     */
    function show($template = null) 
    {
          
          $title = $this->getPage()->getTemplate()->getTitleText();
          $this->getPage()->getTemplate()->setTitleText($title . ' - Orphaned Pages');
    }
    
      
}

/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_PageIdCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * Get the table data from an object if available
     * 
     * @param Dk_Object $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        return $obj->getId();
    }
}


?>