<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Search_Results extends Ext_Web_Component
{
    /**
     * @var Dk_Util_Array
     */
    private $list = null;
    

    /**
     * The default init method
     *
     */
    function init() 
    {
        
        $keywords = $this->getRequest()->getParameter('keywords');
        
        $limit = 15;
        $offset = 0;
        if ($this->getRequest()->exists('offset')) {
            $offset = intval($this->getRequest()->getParameter('offset'));
        }
        //$this->list = Ext_Db_PageMapper::textSearch($keywords, '', '`score` DESC', $limit, $offset);
        $this->list = Ext_Db_PageMapper::textSearch($keywords, 'WITH QUERY EXPANSION', '`score` DESC', $limit, $offset);
        if ($this->list->count() < 10) {
            $this->list = Ext_Db_PageMapper::textSearch($keywords, 'IN BOOLEAN MODE', '`score` DESC', $limit, $offset);
        }
        
        
        $pager = Dk_Ui_Pager::makeFromList($this->list);
        $this->addChild($pager);
    }
    
    /**
     * The default show method.
     *
     */
    function show($template = null) 
    {
        if ($this->list == null || $this->list->count() <= 0) {
            $template->setChoice('error');
            return;
        }
        $template->setChoice('noError');
        $template->replaceText('keywords', '`'.$this->getRequest()->getParameter('keywords').'`');
        /* @var $page Ext_Db_Page */
        foreach ($this->list as $page) {
            $repeat = $template->getRepeat('row');
            
            $url = $page->getPageUrl();
            
            $repeat->replaceHtml('title', $this->bold($page->getTitle()));
            $repeat->replaceAttr('title', 'href', $url->toString());
            $repeat->replaceText('url', substr($url->toString(), 0, 128));
            $repeat->replaceAttr('url', 'href', $url->toString());
            $repeat->replaceAttr('url', 'title', $url->toString());
            
            $repeat->replaceText('modified', $page->getModified()->getMediumDate(true));
            
            $text = Ext_Db_TextMapper::find($page->getCurrentTextId());
            $content = substr(strip_tags($text->getText()), 0, 200);
            $repeat->replaceHTML('content', $this->bold($content));
            $repeat->replaceText('size', Dk_Util_Path::bytes2String($page->getSize()));
            //$repeat->replaceText('score', round((($page->getScore()/6)*100), 2) . '%');
            $repeat->replaceText('score', round((($page->getScore())), 2));
            
            $repeat->append();
        }
    }

    /**
     * 
     *
     * @param unknown_type $str
     * @return unknown
     */
    private function bold($str)
    {
        $arr = explode(' ', $this->getRequest()->getParameter('keywords'));
        foreach ($arr as $key) {
            $pattern = "/(?!<.*?)(".preg_quote($key,'/').")(?![^<>]*?>)/si";
            $replacement = "<strong>\\1</strong>";
            $str = preg_replace($pattern, $replacement, $str); 
        }
        return $str;
    }
	  
}
?>