<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Page_View extends Ext_Web_Component
{
    /**
     * @var Ext_Db_Page
     */
    private $page = null;
    
    /**
     * @var Ext_Db_Text
     */
    private $text = null;
    
    
    /**
     * Enter description here...
     *
     */
    function __construct()
    {
       parent::__construct();
       $this->addEvent('rss', 'doRss');
    }

    /**
     * The default init method
     *
     */
    function init() 
    {
        // Check all view conditions
        if ($this->getRequest()->exists('textId')) {
            $this->text = Ext_Db_TextMapper::find($this->getRequest()->getParameter('textId'));
            if ($this->text == null) {
          	    throw new Dk_ExceptionNullPointer('Invalid `textId` please try another ID.');
          	}
          	$this->page = Ext_Db_PageMapper::find($this->text->getPageId());
          	if ($this->page == null) {
          	    throw new Dk_ExceptionNullPointer('Invalid `pageId` please try another ID.');
          	}
        } else if ($this->getRequest()->exists('pageId')) {
            $this->page = Ext_Db_PageMapper::find($this->getRequest()->getParameter('pageId')); // Get the home page
        } else if ($this->getRequest()->exists('pageName')) {
            $this->page = Ext_Db_PageMapper::findByName($this->getRequest()->getParameter('pageName'));
        } else if ($this->getRequest()->getRequestUri()->getBasename() == 'index.html') {
    	    $this->page = Ext_Db_PageMapper::findByName('Home'); // Get the home page
        }
        
        // Check if we should go into edit page mode automaticaly
        if ($this->page == null) {
            $this->edit($this->getRequest()->getParameter('pageName'));
        }
        
        // If all else fails load home page.
      	if ($this->page == null) {
      	    $this->page = Ext_Db_PageMapper::findByName('Home'); // Get the home page
      	}
      	$this->text = Ext_Db_TextMapper::find($this->page->getCurrentTextId());
      	if ($this->text == null ) {
      	    $this->edit($this->getRequest()->getParameter('pageName'));
      	    return;
      	}
    }
    
    
    function doRss()
    {
        $list = Ext_Db_TextMapper::findByPageId($this->page->getId(), '`created` DESC', 5);
        $rssRender = new Dk_Xml_RssRenderer($list, $this->page->getTitle(), new Dk_Util_Url('/page/'.$this->page->getName()));
        $rssRender->show();
    }
    
    /**
     * Redirect to the edit url if content empty
     *
     * @param string $pageName
     */
    function edit($pageName)
    {
        if (!$this->isUser()) {
            if ($pageName == 'Home') {
                $url = new Dk_Util_Url('/login.html');
                $url->redirect();
            }
        } else {
            if ($pageName) {
                $url = new Dk_Util_Url('/edit.html');
                $url->setQueryField('pageName', $pageName);
                $url->redirect();
            }
        }
    }
    
    
    /**
     * The default show method.
     *
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        if ($this->page == null || $this->text == null) {
            $template->setChoice('error');
            return;
        }
        $template->setChoice('noError');
        
        
      	$template->replaceText('title', $this->page->getTitle());
        $title = $this->getPage()->getTemplate()->getTitleText();
        $this->getPage()->getTemplate()->setTitleText($title . ' - ' . $this->page->getTitle());
      	if ($this->text) {
      	    $template->replaceHtml('text', $this->text->getWikiText());
            $template->replaceText('textId', $this->text->getId());
            $template->replaceText('pageId', $this->page->getId());
            if ($this->text->getCreated()) {
                $template->replaceText('modified', $this->text->getCreated()->getLongDate(true));
            }
      	}
      	
      	$author = Ext_Db_UserMapper::find($this->page->getUserId());
      	if ($author) {
      	    $template->replaceText('author', $author->getName());
      	    if ($author->getImage()) {
                $template->replaceAttr('image', 'src', $author->getImageUrl());
                $template->replaceAttr('image', 'alt', $author->getName());
                $template->replaceAttr('image', 'title', $author->getName());
      	        $template->setChoice('image');
      	    }
      	}
      	
      	$rssUrl = $this->getRequest()->getRequestUri();
      	$rssUrl->resetQueryFields();
      	$rssUrl->setQueryField('rss', 'rss');
      	$template->replaceAttr('rssUrl', 'href', $rssUrl);
      	
  	    if ($this->isUser()) {
  	        $template->setChoice('user');
  	    }
  	    
  	    // Get contributers
  	    $users = Ext_Db_UserMapper::findContributers($this->page->getId());
  	    if ($users->count()) {
  	        $list = '';
  	        foreach ($users as $u) {
  	            $list .= $u->getName() . ', ';
  	        }
  	        $list = substr($list, 0, -2);
  	        $template->replaceText('contrib', $list);
  	        $template->setChoice('contrib');
  	    }
  	    
      	if($this->getRequest()->getReferer() == null) {
      	    return;
      	}
      	
      	if ($this->getRequest()->exists('textId') && $this->getRequest()->getReferer()->getBasename() == 'history.html') {
      	  
      	    $template->setChoice('revision');
      	    
      	    $url = new Dk_Util_Url('/history.html');
      	    $url->setQueryField('pageName', $this->page->getName());
      	    $template->replaceAttr('backUrl', 'href', $url->toString());
      	
            if ($this->getUser() && $this->page->getLock()->isEditable($this->getUser()->getId())) {
                $template->setChoice('revert');
                $url = new Dk_Util_Url('/history.html');
                $url->setQueryField('revert', $this->page->getId());
                $template->replaceAttr('revertUrl', 'href', $url->toString());
            }
      	    
      	} else if ($this->getRequest()->exists('pageId') && $this->getRequest()->getReferer()->getBasename() == 'orphaned.html') {
      	    
      	    $template->setChoice('orphaned');
      	    
      	    $url = new Dk_Util_Url('/orphaned.html');
      	    $template->replaceAttr('backUrl', 'href', $url->toString());
      	    
            if ($this->getUser() && $this->page->getLock()->isEditable($this->getUser()->getId())) {
                $template->setChoice('delete');
          	    $url = new Dk_Util_Url('/orphaned.html');
          	    $url->setQueryField('delete', $this->page->getId());
          	    $template->replaceAttr('deleteUrl', 'href', $url->toString());
            }
      	}
    
        if ($this->getUser() && !$this->page->getLock()->isEditable($this->getUser()->getId())) {
            $template->setChoice('locked');
        }
    }
    
    
    
    
    
	
}
?>