<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Page_History extends Ext_Web_Component
{
    /**
     * @var Ext_Db_Page
     */
    private $page = null;
    
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('revert', 'doRevert');
    }

    /**
     * The default init method
     *
     */
    function init() 
    {
        if (!$this->getRequest()->exists('pageName')) {
            $this->getRequest()->setParameter('pageName', 'Home');
        }
        $this->page = Ext_Db_PageMapper::findByName($this->getRequest()->getParameter('pageName'));
        
        // Create a new page
        if ($this->page == null) {
            throw new Dk_ExceptionRuntime('No Revisions available.');
        }
        
        
        
        // Get orderby, limit, offset
        $loo = Dk_Util_Loo::createFromRequest($this->getId());
        
        // Get DB results list
        $list = Ext_Db_TextMapper::findByPageId($this->page->getId(), $loo->getOrderBy(), $loo->getLimit(), $loo->getOffset());
        
        // create table manager
        $cManager = new Dk_Ui_Table_Base($list);
        $this->addChild($cManager);
        
        $cells = array();
        //$cells['C'] = 'Dk_Ui_Table_CheckboxCell';
        $cells['revisionId'] = 'Ext_Modules_RevisionIdCell';
        $cells['userId'] = 'Ext_Modules_UserIdCell';
        $cells['created'] = 'Dk_Util_DateCell';
        if ($this->isUser() && $this->page->getLock()->isEditable($this->getUser()->getId())) {
            $cells['Actions'] = 'Ext_Modules_AdminActionCell';
        } else {
            $cells['Actions'] = 'Ext_Modules_ActionCell';
        }
        
        $cellArray = Dk_Ui_Table_CellFactory::createCellsFromArray($cells, 'revisionId', new Dk_Util_Url('/index.html'));
        $cManager->setCells($cellArray);
        
        
    }
    
    /**
     * The default event handler.
     * 
     */
    function doDefault() 
    { 
        
    }
    
    
    
    /**
     * The default event handler.
     * 
     */
    function doRevert() 
    {
        $text = Ext_Db_TextMapper::find($this->getRequest()->getParameter('revert'));
        if ($text == null) {
              throw new Dk_ExceptionNullPointer('Invalid `textId` please try another ID.');
          }
          $page = Ext_Db_PageMapper::find($text->getPageId());
          if ($page == null) {
              throw new Dk_ExceptionNullPointer('Invalid `pageId` please try another ID.');
          }
          
        if ($this->isUser()) {
              $page->setCurrentTextId($text->getId());
              $page->update();
        }
        
        $url = $page->getPageUrl();
        $url->redirect();
    }
    
    
    
    /**
     * The default show method.
     *
     */
    function show($template = null) 
    {
          $template->replaceText('title', $this->page->getTitle());
          $title = $this->getPage()->getTemplate()->getTitleText();
          $this->getPage()->getTemplate()->setTitleText($title . ' - ' . $this->page->getTitle() . ' Revisions');
          
          if ($this->isUser() && $this->page->getLock()->isEditable($this->getUser()->getId())) {
              $template->setChoice('revert');
          }
    }
    
      
}

/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_RevisionIdCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * Get the table data from an object if available
     * 
     * @param Dk_Object $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        return $obj->getId();
    }
}


/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_UserIdCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * Get the table data from an object if available
     * 
     * @param Dk_Object $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        $user = Ext_Db_UserMapper::find($obj->getUserId());
        if ($user) {
            return $user->getName();
        }
        return 'N/A';
    }
}

/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_ActionCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * get teh table data from an object if available
     *
     * @param Dk_Object $obj
     * @return string
     */
    function getTableData($obj)
    {
        $str = '';
        
        if ($this->actionUrlParam == null) {
            $pos = strrpos(get_class($obj), '_');
            $this->actionUrlParam = strtolower(substr(get_class($obj), $pos+1)).'Id';
        }
        
        $url = new Dk_Util_Url('/index.html');
        $url->setQueryField($this->actionUrlParam, $obj->getId());
        $str .= '<a href="' . $url->toString() . '">View</a>';
        
        return $str;
    }
}

/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_AdminActionCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * get teh table data from an object if available
     *
     * @param Dk_Object $obj
     * @return string
     */
    function getTableData($obj)
    {
        $str = '';
        
        if ($this->actionUrlParam == null) {
            $pos = strrpos(get_class($obj), '_');
            $this->actionUrlParam = strtolower(substr(get_class($obj), $pos+1)).'Id';
        }
        
        $url = Dk_Request::getInstance()->getRequestUri();
        $url->setQueryField('revert', $obj->getId());
        $str .= '<a href="' . $url->toString() . '" onclick="return confirm(\'Do you want to revert this page to revision '.$obj->getId().'?\');">Revert</a> &#160; ';
        
        $url = new Dk_Util_Url('/index.html');
        $url->setQueryField($this->actionUrlParam, $obj->getId());
        $str .= '<a href="' . $url->toString() . '">View</a>';
        
        return $str;
    }
}
?>