<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Page_Edit extends Ext_Web_Component
{
    /**
     * @var Ext_Db_Page
     */
    private $page = null;
    
    /**
     * @var Ext_Db_Text
     */
    private $text = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('save', 'doSubmit');
        //$this->addEvent('preview', 'doPreview');
        $this->addEvent('ping', 'doPing');
        $this->addEvent('cancel', 'doCancel');
        
        $this->setAccessGroup(Ext_Db_User::GROUP_USER);
    }

    /**
     * The default init method
     *
     */
    function init() 
    {
        if (!$this->getRequest()->exists('pageName')) {
            $this->getRequest()->setParameter('pageName', 'Home');
        }
        
        $this->page = Ext_Db_PageMapper::findByName($this->getRequest()->getParameter('pageName'));
        
        // Create a new page
        if ($this->page == null) {
            $this->page = new Ext_Db_Page();
            $this->page->setUserId($this->getUser()->getId());
            $this->page->setTitle(str_replace('_', ' ', $this->getRequest()->getParameter('pageName')));
            $this->page->setName($this->getRequest()->getParameter('pageName'));
        }
        $this->text = new Ext_Db_Text();
        $this->text->setUserId($this->getUser()->getId());
        if ($this->page->getCurrentTextId() > 0) {
            $oldText = Ext_Db_TextMapper::find($this->page->getCurrentTextId());
            if ($oldText) {
                $this->text->setText($oldText->getText());
            }
        }
        
        $form = new Dk_Form_Object('Edit');
        $form->addField('title');
        $form->addField('keywords');
        //$form->addField('css');
        //$form->addField('javascript');
        $form->addField('text');
        $this->setForm($form);
    }
    
    /**
     * The default event handler.
     * 
     */
    function doDefault() 
    { 
        $this->getForm()->loadFromObject($this->page);
        $this->getForm()->loadFromObject($this->text);
    
        if (!$this->getUser()) {
            return;
        }
        if ($this->page && $this->page->getLock()) {
            if (!$this->page->getLock()->isEditable($this->getUser()->getId())) {
                $url = $this->page->getPageUrl();
                $url->redirect();
            } else {
                $this->page->getLock()->lock($this->getUser()->getId());
            }
        }
    }
    
    /**
     * The default event handler.
     * 
     */
    function doSubmit() 
    { 
        $request = $this->getRequest();
        
        $this->getForm()->loadFromRequest($request);
        $this->getForm()->loadObject($this->page);
        $this->getForm()->loadObject($this->text);
        
        $valid = $this->page->validate();
        $this->getForm()->addFieldErrors($valid->getErrors());
        $valid = $this->text->validate();
        $this->getForm()->addFieldErrors($valid->getErrors());
        
        if ($this->getForm()->hasErrors()) {
            return;
        }
        
        if ($this->page->getId() == 0) {
            if ($this->text->getText() != null) {
                $pageId = $this->page->insert();
                $this->text->setPageId($pageId);
                $textId = $this->text->insert();
                $this->page->setCurrentTextId($textId);
                $size = sizeof($this->text->getSize());
                $this->page->setSize($size);
            }
        } else {
            $oldText = Ext_Db_TextMapper::find($this->page->getCurrentTextId());
            if ($this->text->getText() != null && ($oldText == null || $oldText->getText() != $this->text->getText()))
            {
                $this->text->setPageId($this->page->getId());
                $textId = $this->text->insert();
                $this->page->setCurrentTextId($textId);
                $this->page->setSize($this->text->getSize());
            } else if ($this->text->getText() == null) {
                $this->page->delete();
            }
        }
        if ($this->page->getLock()) {
            $this->page->getLock()->unlock($this->getUser()->getId());
        }
        $this->page->update();
        
        $url = $this->page->getPageUrl();
        $url->redirect();
    }
    
    /**
     * Redirect to thte view/home page
     * 
     */
    function doCancel() 
    { 
        if ($this->page->getLock()) {
            $this->page->getLock()->unlock($this->getUser()->getId());
        }
        
        if ($this->page->getId() > 0) {
            $url = $this->page->getPageUrl();
            $url->redirect();
        } else {
            $url = new Dk_Util_Url('/index.html');
            if ($this->getRequest()->getReferer() && 
                $this->getRequest()->getReferer()->getBasename() != $this->getRequest()->getRequestUri()->getBasename()) 
            {
                $this->getRequest()->getReferer();
            }
            $url->redirect();
        }
    }
    
    /**
     * doPing
     *
     */
    function doPing()
    {
        $this->page->getLock()->lock($this->getUser()->getId());
        //echo "Success";
        exit;
    }
    
    
    
    /**
     * The default show method.
     *
     */
    function show($template = null) 
    {
          $template->replaceText('title', 'Editing: ' . $this->page->getTitle());
          $sessionName = Dk_Session::getInstance()->getName();
          $mceRenderer = new Jdk_Ui_TinyMce();
          $mceRenderer->setPublicFilePath($this->getConfig()->getDataDir().'/media');
          $init = "
tinyMCE.init({
    mode : 'textareas',
    theme : 'advanced',
    skin : 'o2k7',
    editor_selector : 'mceEditor',
    editor_deselector : 'mceNoEditor',
    plugins : 'safari,pagebreak,style,table,save,advimage,advlink,inlinepopups,insertdatetime,searchreplace,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,jdkmanager,wikiCreatePage,wikiFindPage',
    theme_advanced_buttons1 : 'save,|,wikiCreatePage,wikiFindPage,jdkmanager,|,bold,italic,underline,strikethrough,|,forecolor,backcolor,formatselect,fontselect,fontsizeselect',
    theme_advanced_buttons2 : 'justifyleft,justifycenter,justifyright,justifyfull,|,pastetext,pasteword,search,|,bullist,numlist,|,outdent,indent,blockquote,|,insertdate,inserttime,|,hr,|,sub,sup,|,ltr,rtl,|,link,unlink,anchor,image,nonbreaking',
    theme_advanced_buttons3 : 'tablecontrols,|,charmap,|,removeformat,visualaid,cleanup,code,fullscreen',
    theme_advanced_toolbar_location : 'top',
    theme_advanced_toolbar_align : 'left',
    theme_advanced_statusbar_location : 'bottom',
    theme_advanced_resizing : true,
    content_css : 'css/tinymce.css',
    convert_urls : false,
    relative_urls : false,
    remove_script_host : true,
    save_enablewhendirty : true,
    save_onsavecallback : 'mceSave',
    save_oncancelcallback : 'mceCancel',	
    fix_nesting : true,
    
    dk_sessionName : '{$sessionName}'
});";

          $mceRenderer->setInit($init);
          $mceRenderer->show($template);
    }
      
}
?>