<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A base component object. 
 * 
 * 
 * @package Modules
 */
class Ext_Modules_Menu_TabMenu extends Ext_Web_Component
{
    /**
     * @var Ext_Db_Page
     */
    private $page = null;
    

    /**
     * The default init method
     *
     */
    function init() 
    {
        if ($this->getRequest()->exists('textId')) {
            $text = Ext_Db_TextMapper::find($this->getRequest()->getParameter('textId'));
            $this->page = Ext_Db_PageMapper::find($text->getPageId());
        } else if (!$this->getRequest()->exists('pageName')) {
            $this->page = Ext_Db_PageMapper::findByName('Home');
        } else {
           $this->page = Ext_Db_PageMapper::findByName($this->getRequest()->getParameter('pageName'));
        }
    }
    
    
    /**
     * The default show method.
     *
     */
    function show($template = null) 
    {
        if ($this->isAdmin()) {
            $template->setChoice('admin');
            $this->getPage()->getTemplate()->setChoice('admin');
        }
      	
        if ($this->isUser()) {
            $this->getPage()->getTemplate()->setChoice('logout');
            $template->setChoice('user');
            $this->getPage()->getTemplate()->setChoice('user');
        } else {
            $this->getPage()->getTemplate()->setChoice('login');
        }
          
      	if (!$this->page) {
      	    return;
      	}
      	
      	$template->setChoice('show');
      	
      	
        $url = new Dk_Util_Url('/edit.html');
        $url->setQueryField('pageName', $this->page->getName());
        $template->replaceAttr('editUrl', 'href', $url->toString());
        
        $url = new Dk_Util_Url('/page/'.$this->page->getName());
        $template->replaceAttr('viewUrl', 'href', $url->toString());
    	
      	$url = new Dk_Util_Url('/history.html');
      	$url->setQueryField('pageName', $this->page->getName());
      	$template->replaceAttr('historyUrl', 'href', $url->toString());
      	if (!$this->getUser()) {
      	    return;
      	}
      	switch ($this->getRequest()->getRequestUri()->getBasename()) {
      	    case 'edit.html':
      	        if (!$this->page->getLock()->isEditable($this->getUser()->getId())) {
      	             $template->replaceAttr('edit', 'class', 'disabled');
      	             $template->replaceAttr('editUrl', 'href', 'javascript:;');
                } else {
                     $template->replaceAttr('edit', 'class', 'selected');
                }
                
      	        break;
      	    case 'history.html':
      	        $template->replaceAttr('history', 'class', 'selected');
      	        break;
      	    case 'settings.html':
      	        $template->replaceAttr('settings', 'class', 'selected');
      	        break;
      	    case 'userManager.html':
      	        $template->replaceAttr('userManager', 'class', 'selected');
      	        break;
      	    case 'orphaned.html':
      	        $template->replaceAttr('orphaned', 'class', 'selected');
      	        break;
      	    default:
      	        $template->replaceAttr('view', 'class', 'selected');
      	}
      	
    }
    
    
    
    
    
    
    
	
}
?>