<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Db_UserMapper extends Dk_Mapper_Object 
{
    
    /**
     * Load the data map
     *
     */
    function loadDataMap()
    {
        $this->dataMap = new Dk_Mapper_DataMap(array('tableName' => 'user'));

        $this->dataMap->addIdColumn('id', 'id', Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn('name', 'name', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('email', 'email', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('image', 'image', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('active', 'active', Dk_Db_ColumnMap::CM_BOOLEAN);
        $this->dataMap->addColumn('username', 'username', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('password', 'password', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('group', 'group', Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn('hash', 'hash', Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn('modified', 'modified', 'Dk_Util_Date');
        $this->dataMap->addColumn('created', 'created', 'Dk_Util_Date');
        

    }

    // ------- Add custom query methods below. -------
    
    
    /**
     * Find by its id
     *
     * @param integer $id
     * @return Ext_Db_User
     */
    static function find($id)
    {
        return self::makeMapper(__CLASS__)->select($id);
    }
    
    /**
     * Find all
     * 
     * @param Dk_Util_Loo $loo
     * @return Dk_Db_Array
     */
    static function findAll($loo = null)
    {
        return self::makeMapper(__CLASS__)->looSelect('', $loo);
    }
    
    
    
    
    
    /**
     * Find by username
     * 
     * @param string $username
     * @return Ext_Db_User
     */
    static function findByUsername($username)
    {
        $username = Dk_Db_MyDao::escapeString($username);
        $arr = self::makeMapper(__CLASS__)->looSelect('`username` = \''.$username.'\' AND `active` = 1');
        return $arr->getFirst();
    }
    
    /**
     * Find by hash
     * 
     * @param string $hash
     * @return Ext_Db_User
     */
    static function findByHash($hash)
    {
        $hash = Dk_Db_MyDao::escapeString($hash);
        $arr = self::makeMapper(__CLASS__)->looSelect('`hash` = \'' . $hash . '\' AND `active` = 0');
        return $arr->getFirst();
    }
    
    /**
     * Find by email
     * 
     * @param Dk_Util_Loo $loo
     * @return Ext_Db_User
     */
    static function findByEmail($email)
    {
        $email = Dk_Db_MyDao::escapeString($email);
        $arr = self::makeMapper(__CLASS__)->looSelect('`email` = \''.$email.'\'');
        return $arr->getFirst();
    }
    
    /**
     * Find by email
     * 
     * @param Dk_Util_Loo $loo
     * @return Dk_Db_Array
     */
    static function findByGroup($group = 0, $loo = null)
    {
        $group = intval($group);
        $where = '';
        if ($group > 0) {
             $where = sprintf('`group` = %d', $group);
        }
        $arr = self::makeMapper(__CLASS__)->looSelect($where, $loo);
        return $arr;
    }
    

    /**
     * Find all users who contributed to the article but not the author
     * 
     * @param Dk_Util_Loo $loo
     * @return Dk_Db_Array
     */
    static function findContributers($pageId, $loo = null)
    {
        if ($loo == null) {
            $loo = new Dk_Util_Loo(0, 0, `name`);
        }
        $pageId = intval($pageId);
        // Get the page Author
        $page = Ext_Db_PageMapper::find($pageId);
        if (!$page) {
            return new Dk_Db_Array();
        }
        
        
        $from = sprintf('`user` u, `text` t');
        $where = sprintf('u.`id` = t.`userId` AND u.`id` != %d', $page->getUserId());
        
        $arr = self::makeMapper(__CLASS__)->selectFrom($from, $where, $loo->getOrderBy(), $loo->getLimit(), $loo->getOffset(), 'u', true);
        return $arr;
    }
    
    
    
    /**
     * Clean non-confirmed account after 1 week
     * 
     * @return integer
     */
    static function cleanNonConfirmed()
    {
        $cutoff = Dk_Util_Date::createDate()->addDays(-7);
        $query = sprintf('DELETE FROM `%s` WHERE `hash` != \'\' AND `active` = 0 AND `created` <= \'%s\'', self::makeMapper(__CLASS__)->getTable(), $cutoff->getIsoDate());
        self::makeMapper(__CLASS__)->getDb()->query($query);
        return self::makeMapper(__CLASS__)->getDb()->getAffectedRows();
    }
    
}
?>