<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Db_TextMapper extends Dk_Mapper_Object 
{

    
    /**
     * Load the data map
     *
     */
    function loadDataMap()
    {
        $this->dataMap = new Dk_Mapper_DataMap(array('tableName' => 'text'));

        $this->dataMap->addIdColumn("id", "id", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("pageId", "pageId", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("userId", "userId", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("text", "text", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("created", "created", 'Dk_Util_Date');
        

    }

    // ------- Add custom query methods below. -------

    /**
     * Find by its id
     *
     * @param integer $id
     * @return Ext_Db_Text
     */
    static function find($id)
    {
        return self::makeMapper(__CLASS__)->select($id);
    }

    /**
     * Find all
     * 
     * @param integer $orderBy
     * @param integer $limit
     * @param integer $start
     * @return Dk_Db_Array
     */
    static function findAll($orderBy = 'id', $limit = -1, $start = 0)
    {
        return self::makeMapper(__CLASS__)->selectMany("", $orderBy, $limit, $start);
    }
    
    /**
     * Find a records by pageId
     *
     * @param string $title
     * @return Dk_Db_Array
     */
    static function findByPageId($pageId, $orderBy = '`created` DESC', $limit = -1, $offset = 0)
    {
        $pageId = intval($pageId);
        $where = sprintf("`pageId` = '%d'", $pageId);
        $arr = self::makeMapper(__CLASS__)->selectMany($where,  $orderBy, $limit, $offset);
        return $arr;
    }
    

    /**
     * Delete this object from the database.
     * Returns The number of affected rows.
     * 
     * @param integer $pageId
     * @return integer
     */
    static function deleteByPageId($pageId)
    {
        $pageId = intval($pageId);
        $where = "`pageId` = $pageId";
        $query = sprintf('DELETE FROM `%s` WHERE %s', self::makeMapper(__CLASS__)->getTable(), $where);
        self::makeMapper(__CLASS__)->getDb()->query($query);
        return self::makeMapper(__CLASS__)->getDb()->getAffectedRows();
    }
    
    
    
}
?>