<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Db_Text extends Dk_Db_Object implements Dk_Xml_RssInterface
{
    
    /**
     * @var integer
     */
    protected $pageId = 0;
     
    /**
     * @var integer
     */
    protected $userId = 1;
    
    /**
     * @var string
     */
    protected $text = '';
    
    /**
     * @var Dk_Util_Date
     */
    protected $created = null;
    
    

    /**
     * __construct
     *
     */
    function __construct()
    {
        $this->created = Dk_Util_Date::createDate();
        
    }

    
    /**
     * This object does not update
     *
     * @param Ext_Db_Text $obj
     * @return integer
     */
    function insert()
    {
        $id = parent::insert();
        $template = Dom_Template::loadXml('<div></div>');
        $doc = $template->getDocument(false);
        Dom_Template::insertHTML($doc->documentElement, $this->getText());
        Ext_Db_PageMapper::deleteLinkByPageId($this->getPageId());
        $nodeList = $doc->getElementsByTagName('a');
        foreach ($nodeList as $node) {
            $regs = array();
            if (ereg('^page://(.+)', $node->getAttribute('href'), $regs)) {
                Ext_Db_PageMapper::insertPageLink($this->getPageId(), $regs[1]);
            }
        }
        return $id;
    }
    
    /**
     * This object does not have an update
     *
     * @param Ext_Db_Text $obj
     */
    function update()
    {
        return false;
    }


    
    /**
     * The current content record to associate this page with
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @return integer
     */
    function getPageId()
    {
        return $this->pageId;
    }
    
    /**
     * The current content record to associate this page with
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @param integer $i
     */
    function setPageId($i)
    {
        $this->pageId = $i;
    }
    
    /**
     * The user who edited the page
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @return integer
     */
    function getUserId()
    {
        return $this->userId;
    }
    
    /**
     * The user who edited the page
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @param integer $i
     */
    function setUserId($i)
    {
        $this->userId = $i;
    }
    
    /**
     * Get text
     * Safe Range: A string with a maximum length of 65,535
     *  characters.
     *
     * @return string
     */
    function getText()
    {
        return $this->text;
    }
    
    /**
     * Set text
     * Safe Range: A string with a maximum length of 65,535
     *  characters.
     *
     * @param string $value
     */
    function setText($value)
    {
        $this->text = $value;
    }
    
    /**
     * Get created
     * Range: '1000-01-01 00:00:00' to '9999-12-31
     *  23:59:59'. DB values in 'YYYY-MM-DD HH:MM:SS' format.
     *
     * @return Dk_Util_Date
     */
    function getCreated()
    {
        return $this->created;
    }
    
    

    /**
     * getParsedText
     * 
     * @return string
     */
    function getWikiText()
    {
        $template = Dom_Template::loadXml('<div></div>');
        $doc = $template->getDocument(false);
        Dom_Template::insertHTML($doc->documentElement, $this->text);
        
        $nodeList = $doc->getElementsByTagName('a');
        foreach ($nodeList as $node) {
            $regs = array();
            if (ereg('^page://(.+)', $node->getAttribute('href'), $regs)) {
                $url = new Dk_Util_Url('/page/'.$regs[1]);
                $page = Ext_Db_PageMapper::findByName($regs[1]);
                if ($page) {
                    $node->setAttribute('class', 'wikiPage');
                } else {
                    $node->setAttribute('class', 'newWikiPage');
                }
                $node->setAttribute('href', $url->toString());
            } else if (ereg('^http|ftp|telnet|gopher|news', $node->getAttribute('href'), $regs)) {
                $url = new Dk_Util_Url($node->getAttribute('href'));
                if ($url->getHost() != $_SERVER['HTTP_HOST']) {
                    $node->setAttribute('class', 'externalLink');
                    $node->setAttribute('target', '_blank');
                }
            }
        }
        
        $str = $doc->saveHTML();
        return $str;
    }
    
    /**
     * Get the size in bytes of the text data
     *
     * @return integer
     */
    function getSize()
    {
        return str2Bytes($this->getText());
    }
    
    
    
    /**
     * Get the Title string
     *
     * @return string
     */
    function getRssTitle()
    {
        $page = Ext_Db_PageMapper::find($this->getPageId());
        return $page->getTitle();
    }
    
    /**
     * Get the Description string
     *
     * @return string
     */
    function getRssDescr()
    {
        //$page = Ext_Db_PageMapper::find($this->getPageId());
        return $this->getWikiText();
    }
    
    /**
     * Get the item view url
     *
     * @return Dk_Util_Url
     */
    function getRssLink()
    {
        $page = Ext_Db_PageMapper::find($this->getPageId());
        $url = new Dk_Util_Url('/page/' . $page->getTitle());
        return $url;
    }
    
    
    
    
}

/**
 * A validator object for the Ext_Db_Text object
 *
 * @package Util
 */
class Ext_Db_TextValidator extends Dk_Util_Validator
{

    /**
     * @var Ext_Db_Text
     */
    protected $obj = null;

    /**
     * Validates
     *
     */
    function validate()
    {
        
        if ($this->obj->getPageId() > 0) {
            $this->setError('pageId', 'Invalid Page ID.');
        }
        
//        if (!ereg('^.*$', $this->obj->getText())) {
//            $this->setError('text', 'Invalid Text Data.');
//        }
    }

}
?>