<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Db_PageMapper extends Dk_Mapper_Object 
{

    
    /**
     * Load the data map
     *
     */
    function loadDataMap()
    {
        $this->dataMap = new Dk_Mapper_DataMap(array('tableName' => 'page'));

        $this->dataMap->addIdColumn("id", "id", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("currentTextId", "currentTextId", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("userId", "userId", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("title", "title", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("name", "name", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("keywords", "keywords", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("css", "css", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("javascript", "javascript", Dk_Db_ColumnMap::CM_STRING);
        $this->dataMap->addColumn("hits", "hits", Dk_Db_ColumnMap::CM_INTEGER);
        $this->dataMap->addColumn("size", "size", Dk_Db_ColumnMap::CM_FLOAT);
        $this->dataMap->addColumn("score", "score", Dk_Db_ColumnMap::CM_FLOAT);
        $this->dataMap->addColumn("modified", "modified", 'Dk_Util_Date');
        $this->dataMap->addColumn("created", "created", 'Dk_Util_Date');
        
    }

    // ------- Add custom query methods below. -------

    /**
     * Find by its id
     *
     * @param integer $id
     * @return Ext_Db_Page
     */
    static function find($id)
    {
        return self::makeMapper(__CLASS__)->select($id);
    }

    /**
     * Find all
     * 
     * @param integer $orderBy
     * @param integer $limit
     * @param integer $offset
     * @return Dk_Db_Array
     */
    static function findAll($orderBy = 'id', $limit = -1, $offset = 0)
    {
        return self::makeMapper(__CLASS__)->selectMany("", $orderBy, $limit, $offset);
    }
    
    
    
    
    /**
     * Find a page(s) by its non-unique title
     *
     * @param string $title
     * @return Dk_Db_Array
     */
    static function findByTitle($title) 
    {        
        $title = Dk_Db_MyDao::escapeString($title);
        $where = sprintf("`title` = '%s'", $title);
        return self::makeMapper(__CLASS__)->selectMany($where, 'id', 1, 0);
    }
    
    /**
     * Find a page by its unique Name
     *
     * @param string $title
     * @return Ext_Db_Page Returns null if not found
     */
    static function findByName($title) 
    {        
        $title = Dk_Db_MyDao::escapeString($title);
        $where = sprintf("`name` = '%s'", $title);
        $arr = self::makeMapper(__CLASS__)->selectMany($where, 'id', 1, 0);
        if ($arr->count() > 0) {
            return $arr[0];
        }
    }
    
    /**
     * Return all the Orphaned Pages
     *
     * @return Dk_Db_Array
     */
    static function findOrphanedPages()
    {
        $mapper = self::makeMapper(__CLASS__);
        $query = sprintf('SELECT %s FROM `%s` p LEFT JOIN `pageLink` pl ON (p.`name` = pl.`pageToName`)
WHERE pl.`pageFrom` IS NULL  AND (p.`name` != \'Home\' AND p.`name` != \'Menu\')',
            $mapper->getSelectList(), $mapper->getTable());
        $result = $mapper->getDb()->query($query);
        return $mapper->loadDbArray($result);
    }
    
    /**
     * insert a page link record
     *
     * @param integer $pageFromId
     * @param string $pageToName
     * @return boolean
     */
    static function insertPageLink($pageFromId, $pageToName)
    {
        $mapper = self::makeMapper(__CLASS__);
        $pageFromId = intval($pageFromId);
        $pageToName = $mapper->getDb()->escapeString($pageToName);
        if (self::pageLinkExists($pageFromId, $pageToName)) {
            return false;
        }
        $query = sprintf("INSERT INTO `pageLink` VALUES (%d, '%s')", $pageFromId, $pageToName);
        $mapper->getDb()->query($query);
        return true;
    }
    
    /**
     * Check if a page link already exists
     *
     * @param integer $pageFromId
     * @param string $pageToName
     * @return boolean
     */
    static function pageLinkExists($pageFromId, $pageToName)
    {
        $mapper = self::makeMapper(__CLASS__);
        $pageFromId = intval($pageFromId);
        $pageToName = $mapper->getDb()->escapeString($pageToName);
        $query = sprintf("SELECT COUNT(*) as i FROM `pageLink` WHERE `pageFrom` = %d AND `pageToName` = '%s'", 
            $pageFromId, $pageToName);
        $result = $mapper->getDb()->query($query);
        $value = $result->current();
        return $value['i'] > 0;
    }
    
    /**
     * delete a specific page link
     *
     * @param integer $pageFromId
     * @param string $pageToName
     * @return integer
     */
    static function deletePageLink($pageFromId, $pageToName)
    {
        $mapper = self::makeMapper(__CLASS__);
        $pageFromId = intval($pageFromId);
        $pageToName = $mapper->getDb()->escapeString($pageToName);
        if (!self::pageLinkExists($pageFromId, $pageToName)) {
            return 0;
        }
        $where = "`pageFrom` = $pageFromId AND `pageToName` = '$pageToName'";
        $query = sprintf('DELETE FROM `pageLink` WHERE %s LIMIT 1', $where);
        $mapper->getDb()->query($query);
        return $mapper->getDb()->getAffectedRows();
    }
    
    /**
     * Delete all links to and from a pageId
     *
     * @param integer $pageId
     * @return integer
     */
    static function deleteLinkByPageId($pageId)
    {
        $mapper = self::makeMapper(__CLASS__);
        $pageId = intval($pageId);
        $where = "`pageFrom` = $pageId";
        $query = sprintf('DELETE FROM `pageLink` WHERE %s', $where);
        $mapper->getDb()->query($query);
        return $mapper->getDb()->getAffectedRows();
    }
    
    /**
     * Enter description here...
     *
     * @param string $keywords
     * @param string $orderBy
     * @param integer $limit
     * @param integer $offset
     * @return Dk_Db_Array
     */
    static function textSearch($keywords = '', $mode = '', $orderBy = '`score` DESC', $limit = 0, $offset = 0)
    {
        $mapper = self::makeMapper(__CLASS__);
        $keywords = Dk_Db_MyDao::escapeString($keywords);
        
        if ($orderBy != '') {
            if (strstr(strtolower($orderBy), 'field') === false) {
                $orderBy = Dk_Db_MyDao::escapeString($orderBy);
            }
            $orderBy = "ORDER BY " . $orderBy;
        }
        $limitStr = '';
        if ($limit > 0) {
            $limitStr = sprintf("LIMIT %d , %d", intval($offset), intval($limit));
        }
        
        $query = sprintf("SELECT %s, (IFNULL(pf.`score`,0) + IFNULL(tf.`score`,0)) AS `score`
FROM `page` p LEFT JOIN (
    SELECT sp1.`id` as `pageId`, sp1.`currentTextId` as `textId`, MATCH (sp1.`title`, sp1.`keywords`) AGAINST ('%s' %s) AS `score`
    FROM `page` sp1
    WHERE MATCH (sp1.`title`, sp1.`keywords`) AGAINST ('%s' %s) 
    Group BY sp1.`name`
    HAVING `score` > 0.0
) pf ON (p.`id` = pf.`pageId`) LEFT JOIN (
    SELECT t.`pageId`, t.`id` as `textId`, MATCH (t.`text`) AGAINST ('%s' %s) AS `score`
    FROM `text` t, `page` sp
    WHERE MATCH (t.`text`) AGAINST ('%s' %s) AND t.`id` = sp.`currentTextId`
    AND t.`id` = sp.`currentTextId`
    Group BY `pageId`
    HAVING `score` > 0.0
) tf ON (p.`id` = tf.`pageId`)
WHERE pf.`pageId` IS NOT NULL OR tf.`pageId` IS NOT NULL AND p.`name` != 'MENU'
GROUP BY p.`id`
HAVING `score` > 0.1

%s %s
", str_replace('p.`score`,', '', $mapper->getSelectList('p')), 
        $keywords, 
        $mode, 
        $keywords, 
        $mode, 
        
        $keywords, 
        $mode, 
        $keywords, 
        $mode, 
        
        $orderBy, $limitStr);
        //vd($query);
        $result = $mapper->getDb()->query($query);
        return $mapper->loadDbArray($result, $orderBy, $limit, $offset);
    }
    
    
}
?>