<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Db_Page extends Dk_Db_Object 
{
     
    /**
     * @var integer
     */
    protected $currentTextId = 0;
     
    /**
     * @var integer
     */
    protected $userId = 1;
    
    /**
     * @var string
     */
    protected $title = '';
    
    /**
     * @var string
     */
    protected $name = '';
    
    /**
     * @var string
     */
    protected $keywords = '';
    
    /**
     * @var string
     */
    protected $css = '';
    
    /**
     * @var string
     */
    protected $javascript = '';
    
    /**
     * @var integer
     */
    protected $hits = 0;
    
    /**
     * @var integer
     */
    protected $size = 0.0;
    
    /**
     * @var integer
     */
    protected $score = 0.0;
    
    /**
     * @var Dk_Util_Date
     */
    protected $modified = null;
    
    /**
     * @var Dk_Util_Date
     */
    protected $created = null;
    
    
    /**
     * @var Ext_Util_PageLock
     */
    private $lock = null;
    
    
    
    /**
     * __construct
     *
     */
    function __construct()
    {
        $this->modified = Dk_Util_Date::createDate();
        $this->created = Dk_Util_Date::createDate();
        
    }
    
    /**
     * Delete the page and all associated records
     *
     * @return integer
     */
    function delete()
    {
        $i = Ext_Db_TextMapper::deleteByPageId($this->getId());
        $i += Ext_Db_PageMapper::deleteLinkByPageId($this->getId());
        $i += parent::delete();
        return $i;
    }
    
    
    /**
     * Get the pageLock object
     *
     * @return Ext_Util_PageLock
     */
    function getLock()
    {
        if ($this->lock == null) {
            if ($this->getId() == null) {
                return;
            }
            $this->lock = new Ext_Util_PageLock($this->getId());
        }
        return $this->lock;
    }
    
    /**
     * Get the page Url
     *
     * @return Dk_Util_Url
     */
    function getPageUrl()
    {
        return new Dk_Util_Url('/page/'.$this->getName());
    }

    
    /**
     * The current content record to associate this page with
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @return integer
     */
    function getCurrentTextId()
    {
        return $this->currentTextId;
    }
    
    /**
     * The current content record to associate this page with
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @param integer $i
     */
    function setCurrentTextId($i)
    {
        $this->currentTextId = $i;
    }
    
    /**
     * The user who created the page
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @return integer
     */
    function getUserId()
    {
        return $this->userId;
    }
    
    /**
     * The user who created the page
     * Safe
     *  Range: A normal-size integer. The signed range is -2147483648 to
     *  2147483647. The unsigned range is 0 to 4294967295.
     *
     * @param integer $i
     */
    function setUserId($i)
    {
        $this->userId = $i;
    }
    
    /**
     * Get title
     * Range: A string with 255 characters.
     *
     * @return string
     */
    function getTitle()
    {
        return $this->title;
    }
    
    /**
     * Set title
     * Range: A string with 255 characters.
     *
     * @param string $value
     */
    function setTitle($value)
    {
        $this->title = $value;
    }
    
    /**
     * Get name, this is the name to use for urls
     * Range: A string with 255 characters.
     * Valid characters are: 'a-zA-Z0-9_-'
     * 
     * 
     * @return string
     */
    function getName()
    {
        return $this->name;
    }
    
    /**
     * Set page name, this is the name to use for urls
     * Range: A string with 255 characters.
     * Valid characters are: 'a-zA-Z0-9_-'
     *
     * @param string $value
     */
    function setName($value)
    {
        $this->name = ereg_replace('[^a-zA-Z0-9_-]', '_', $value);
    }
    
    /**
     * User defined meta keywrds for the internal search engine
     * Range:
     *  A string with 255 characters.
     *
     * @return string
     */
    function getKeywords()
    {
        return $this->keywords;
    }
    
    /**
     * User defined meta keywrds for the internal search engine
     * Range:
     *  A string with 255 characters.
     *
     * @param string $value
     */
    function setKeywords($value)
    {
        $this->keywords = $value;
    }
    
    /**
     * Any user defined css inline styles
     * Safe Range: A string with a
     *  maximum length of 65,535 characters.
     *
     * @return string
     */
    function getCss()
    {
        return $this->css;
    }
    
    /**
     * Any user defined css inline styles
     * Safe Range: A string with a
     *  maximum length of 65,535 characters.
     *
     * @param string $value
     */
    function setCss($value)
    {
        $this->css = $value;
    }
    
    /**
     * Any user defined inline javascript
     * Safe Range: A string with a
     *  maximum length of 65,535 characters.
     *
     * @return string
     */
    function getJavascript()
    {
        return $this->javascript;
    }
    
    /**
     * Any user defined inline javascript
     * Safe Range: A string with a
     *  maximum length of 65,535 characters.
     *
     * @param string $value
     */
    function setJavascript($value)
    {
        $this->javascript = $value;
    }
    
    /**
     * The page views per session
     * Safe Range: A normal-size integer.
     *  The signed range is -2147483648 to 2147483647. The unsigned range is 0
     *  to 4294967295.
     *
     * @return integer
     */
    function getHits()
    {
        return $this->hits;
    }
    
    /**
     * The page views per session
     * Safe Range: A normal-size integer.
     *  The signed range is -2147483648 to 2147483647. The unsigned range is 0
     *  to 4294967295.
     *
     * @param integer $i
     */
    function setHits($i)
    {
        $this->hits = $i;
    }
    
    /**
     * The page content size in bytes
     * Safe Range: A normal-size
     *  integer. The signed range is -2147483648 to 2147483647. The unsigned
     *  range is 0 to 4294967295.
     *
     * @return float
     */
    function getSize()
    {
        return $this->size;
    }
    
    /**
     * The page content size in bytes
     * Safe Range: A normal-size
     *  integer. The signed range is -2147483648 to 2147483647. The unsigned
     *  range is 0 to 4294967295.
     *
     * @param float $i
     */
    function setSize($i)
    {
        $this->size = $i;
    }
    
    /**
     * The page content size in bytes
     * Safe Range: A normal-size
     *  integer. The signed range is -2147483648 to 2147483647. The unsigned
     *  range is 0 to 4294967295.
     *
     * @return float
     */
    function getScore()
    {
        return $this->score;
    }
    
    /**
     * Get modified
     * Range: '1000-01-01 00:00:00' to '9999-12-31
     *  23:59:59'. DB values in 'YYYY-MM-DD HH:MM:SS' format.
     *
     * @return Dk_Util_Date
     */
    function getModified()
    {
        return $this->modified;
    }
    
    /**
     * Get created
     * Range: '1000-01-01 00:00:00' to '9999-12-31
     *  23:59:59'. DB values in 'YYYY-MM-DD HH:MM:SS' format.
     *
     * @return Dk_Util_Date
     */
    function getCreated()
    {
        return $this->created;
    }
    


}

/**
 * A validator object for the Ext_Db_Page object
 *
 * @package Util
 */
class Ext_Db_PageValidator extends Dk_Util_Validator
{

    /**
     * @var Ext_Db_Page
     */
    protected $obj = null;

    /**
     * Validates
     *
     */
    function validate()
    {
        
//        if ($this->obj->getCurrentTextId() == 0) {
//            $this->setError('currentTextId', 'Invalid Field Value.');
//        }
    
        if (!ereg('^.{1,255}$', $this->obj->getName())) {
            $this->setError('title', 'Invalid Page Name Value.');
        }
        if (!ereg('^.{1,255}$', $this->obj->getTitle())) {
            $this->setError('title', 'Invalid Field Value.');
        }
        if (!ereg('^.{0,255}$', $this->obj->getKeywords())) {
            $this->setError('keywords', 'Invalid Field Value.');
        }
        
        if (!ereg('^.*$', $this->obj->getCss())) {
            $this->setError('css', 'Invalid Field Value.');
        }
        if (!ereg('^.*$', $this->obj->getJavascript())) {
            $this->setError('javascript', 'Invalid Field Value.');
        }
        
        /*
        if ($this->obj->getModified() == null) {
            $this->setError('modified', 'Invalid Field Value.');
        }
        if ($this->obj->getCreated() == null) {
            $this->setError('created', 'Invalid Field Value.');
        }
        */
    }

}
?>