<?php
/*
 * This file is part of the ExtLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A config/registry object that configures the Sdk functionality.
 *
 *
 * @package Ext
 */
class Ext_Config extends Dk_Config
{



    /**
     * Get an instance of this object
     *
     * @return Ext_Config
     */
    static function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new Ext_Config();
        }
        return self::$instance;
    }
    
    /**
     * Show/Hide the remote tropotek advert
     *
     * @param boolean $b
     * @default true
     */
    function setShowAdvert($b)
    {
        $this->setEntry('ShowAdvert', $b);
    }

    /**
     * Show/Hide the remote tropotek advert
     *
     * @return boolean
     * @default true
     */
    function getShowAdvert()
    {
        return $this->getEntry('ShowAdvert');
    }

    
    /**
     * If this is false then users cannot register through the site.
     * An admin of the site will have to create user accounts.
     *
     * @param boolean $b
     * @default true
     */
    function setRegistrationEnabled($b)
    {
        $this->setEntry('RegistrationEnabled', $b);
    }

    /**
     * If this is false then users cannot register through the site.
     * An admin of the site will have to create user accounts.
     *
     * @return boolean
     * @default true
     */
    function getRegistrationEnabled()
    {
        return $this->getEntry('RegistrationEnabled');
    }
    
    
    
    
    
    
    /**
     * Set 
     *
     * @param string $str
     * @default 
     */
    function set($str)
    {
        $this->setEntry('', $str);
    }

    /**
     * Get 
     *
     * @return string
     * @default 
     */
    function get()
    {
        return $this->getEntry('');
    }

}
?>
