<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @author Darryl Ross <darryl.ross@aot.com.au>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * For all classes that render dom templates.
 * 
 * This is a good base for all renderer objects that implement the Dom_Template
 * it can guide you to create templates that can be inserted into other template
 * objects.
 * 
 * For objects that have a null template when the method getTemplate() is called
 * the template object is returned. If the current template is null then 
 * the magic method __makeTemplate() will be called to create an internal template.
 * This is a good way to create a default template. But be aware that this will 
 * be a new template and will have to be inserted into its parent using the Dom_Template::insertTemplate()
 * method.
 * 
 * @package Util
 */
abstract class Dom_Renderer implements Dom_RendererInterface
{
    
    /**
     * @var Dom_Template
     */
    private $template = null;
    
    
    
    
    /**
     * Set a new template for this renderer.
     * 
     * @param Dom_Template $template
     */
    function setTemplate(Dom_Template $template)
    {
        $this->template = $template;
    }
    
    /**
     * Get the template
     * This method will try to call the magic method __makeTemplate
     * to create a template if one has not been set by setTemplate().
     * Use this for objects that use an internal templates.
     *
     * @return Dom_Template
     */
    function getTemplate() 
    {
        if ($this->template == null && method_exists($this, '__makeTemplate')) {
            $this->template = $this->__makeTemplate();
        }
        return $this->template;
    }
}
?>