<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/* 
 *        ---- DO NOT EDIT! ----
 * This is the main include file for the DkLib
 * Do not edit this unless you know what you are doing.
 * There should be no need to modify this file as it
 * only sets up the default environment.
 */

/*
 * setup the default Dk Environment.
 *  o add new functions
 *  o remove magic quotes, etc
 */
require_once(dirname(__FILE__) . "/Functions/overrides.php");

/* $autoloadAliases
 *  This is the place to include any 3rd party libs to the Dk system
 *  The auto loader will look for the classname (array key)
 *  then load the file given in the array value. 
 */
if(!isset($autoloadAliases)) {
    $autoloadAliases = array();
}
$autoloadAliases['Cpdf'] = dirname(dirname(__FILE__)) . '/Other/ezPdf/class.pdf.php';
$autoloadAliases['Cezpdf'] = dirname(dirname(__FILE__)) . '/Other/ezPdf/class.ezpdf.php';
require_once(dirname(__FILE__) . "/Functions/autoLoad.php");

/*
 * Setup Dk Exceptions
 * See docs
 */
require_once(dirname(__FILE__)."/Exception.php");

/*
 * Setup the Debugger.
 * Enable/disable the debugger in the config.ini
 */
require_once(dirname(__FILE__)."/Util/Debugger.php");

// Session has 3hrs before cleanup
ini_set('session.gc_maxlifetime', 10800); 

/* $htdocRoot
 *  This should be set to the htdoc root of the site
 *  Eg: /~user/site
 *  No trailing slash!
 */
if(!isset($htdocRoot)) {
    $htdocRoot = dirname($_SERVER['PHP_SELF']);
}

/* $rootPath
 *  This is the filesystem root path of the site
 *  Eg: /home/user/public_html/site
 *  No trailing slash!
 */
if(!isset($rootPath)) {
    $rootPath = dirname(__FILE__);
}

/* $config
 *  Create the global Config object if not created allready
 */
if(!isset($config)) {
    $config = Dk_Config::getInstance();
}

/* $request
 *  Create the global Request object if not created allready
 *  This object replaces the $_REQUEST, $_POST, $_GET vars
 */
if(!isset($request)) {
    $request = Dk_Request::getInstance();
}

/* $response
 *  Create the global Response object if not created allready
 *  This is the buffer to write output to
 */
if(!isset($response)) {
    $response = Dk_Response::getInstance();
}

/* $session
 *  This replaces the $_SESSION var
 *  The md5 hash ensures each individual site has a unique session.
 */
if(!isset($session)) {
    $session = Dk_Session::getInstance(md5($htdocRoot));
}


/*
 * The path prefix is prepended to all relative paths with
 * the Url object
 */ 
Dk_Util_Url::$pathPrefix = $htdocRoot;

/*
 * The path prefix is prepended to all relative file paths with
 * the Path object
 */ 
Dk_Util_Path::$pathPrefix = $rootPath;

/*
 * Init any Singleton objects
 */
Dk_Db_ObjectFactory::getInstance();

/*
 * Set config default values
 * The global config object contains site setup variables 
 * the defaults are setup here in the lib include file
 * 
 */
$server = `hostname`;
if (isset($_SERVER['HTTP_HOST'])) {
    $server = str_replace('www.', '', $_SERVER['HTTP_HOST']);
}

$config->setSiteTitle('DkProject');
$config->setHtdocRoot($htdocRoot);
if (isset($rootPath)) {
  $config->setFileRoot($rootPath);
  $config->setEntry('DkFileRoot', dirname(__FILE__));
  $config->setHtmlTemplates($rootPath.'/html');
  $config->setDataDir($rootPath . '/data');
}
$config->setDebugMode(false);
$config->setDebugEmail('info@'.$server);
$config->setSslEnabled(false);
$config->setTimezone('Australia/Queensland');
$config->setCurrency('AUD');
$config->setLanguage('en');
$config->setCdataFix(true);

?>
