<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * An XML webservice base
 * 
 * @package Ws
 */
abstract class Dk_Xml_Server extends Dk_Object 
{
    /**
     * @var string
     */
    protected $encoding = 'utf-8';
    
    /**
     * @var stdClass
     */
    private $requestObject = null;
    
    
    
    
    /**
     * Main execution thread of the webservice
     * 
     */
    function process()
    {
        $this->requestObject = $this->getRequestObject(Dk_Request::getInstance()->getRawPostData());
        Dk_Response::getInstance()->addHeader('Content-Type', 'text/xml; charset=' . $this->encoding);
        Dk_Response::getInstance()->write('<?xml version="1.0" encoding="' . $this->encoding . '"?>' . "\n");
        $this->doProcess();
    }
    
    /**
     * Implement this method in your own webservice objects.
     *
     */
    abstract protected function doProcess();
    
    
    /**
     * Unserialize this request's RAW_POST_DATA to a stdObject
     *
     * @param string $xmlRequest
     * @return stdClass
     */
    protected function getRequestObject($xmlRequest = '')
    {
        if ($xmlRequest != null && $this->requestObject == null) {
            $dom = new DOMDocument();
            // TODO: validate using DTD
            if (!$dom->loadXML($xmlRequest)) {
                throw new Dk_Exception("Invalid xml request.");
            }
            $this->requestObject = Dk_Xml_Result::domToStdClass($dom->documentElement);
        }
        return $this->requestObject;
    }
    
    /**
     * encode string to put into xml document
     *
     * @param string $value
     * @return string
     */
    protected function encode($value)
    {
        return htmlspecialchars($value, ENT_COMPAT, $this->encoding);
    }
    
    /**
     * Convert a string to its boolean equivalent
     *  o 'true' = true
     *  o '1' = true
     * 
     * @param string $str
     * @return string
     */
    protected function strToBoolean($str) 
    {
        if ($str == 'true' || $str == '1') {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * Set the encoding for the response...
     * EG:
     *  o UTF-8 (defult)
     *  o UTF-16
     *  o ISO-8859-1
     * 
     * @param string $encoding
     */
    function setEncoding($encoding)
    {
        $this->encoding = $encoding;
    }
    
    /**
     * Get teh response encoding type
     *
     * @return string
     */
    function getEncoding()
    {
        return $this->encoding;
    }
    
    /**
     * Get the full list of received headers with the request
     *
     * @return array
     */
    function getHeaderList()
    {
        return apache_request_headers();
    }
    
    /**
     * Get a header value by its name
     *
     * @param string $name
     * @return string Returns null if not exist
     */
    function getHeader($name)
    {
        $headers = $this->getHeaderList();
        if (isset($headers[$name])) {
            return $headers[$name];
        }
    }
}
?>
