<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Render the Rss list to the output
 * 
 * @package Web
 */
class Dk_Xml_RssRenderer extends Dom_Renderer 
{
      
    /**
     * @var Dk_Db_Array
     */
    protected $list = null;
    
    /**
     * @var string
     */
    protected $title = '';
    
    /**
     * @var string
     */
    protected $description = '';
    
    /**
     * @var Dk_Util_Url
     */
    protected $link = '';
    
    
    
    /**
     * __construct
     * 
     * @param Dk_Db_Array $list
     * @param string $title
     * @param string $description
     * @param Dk_Util_Url $link
     */
    function __construct(Dk_Db_Array $list, $title = '', $description = '', $link = null)
    {
        $this->list = $list;
        $this->title = $title;
        $this->description = $description;
        $this->link = $link;
        if ($this->link == null) {
            $this->link = new Dk_Util_Url('/index.html');
        }
    }
    
    /**
     * Enter description here...
     *
     * @return Sdk_Web_Dom_Template
     */
    function __makeTemplate()
    {
        $xml = sprintf('<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
  <channel>
    <title var="title"></title>
    <link var="link">http://www.tropotek.com/</link>
    <atom:link var="atomLink" href="#" rel="self" type="application/rss+xml" />
    <description var="description"></description>
    <lastBuildDate var="now"></lastBuildDate>
    <language>en-us</language>
      
    <item repeat="item">
      <title var="title"></title>
      <link var="link"></link>
      <guid var="link"></guid>
      <pubDate var="created"></pubDate>
      <description var="description"></description>
    </item>
    
  </channel>
</rss>');
        
        return Dom_Template::loadXml($xml);
    }
    
    function setTitle($str)
    {
        $this->title = $str;
    }
    
    function setDescription($str)
    {
        $this->description = $str;
    }
    
    function setLink(Dk_Util_Url $url)
    {
        $this->link = $url;
    }
    
    /**
     * show
     * 
     * @param Dom_Tempalte $template
     */
    function show($template = null)
    {
        $template = $this->getTemplate();
        
        $template->replaceText('title', $this->title);
        $template->replaceText('description', $this->description);
        $template->replaceText('link', $this->link->toString());
        $url = clone $this->link;
        $url->setQueryField('rss', 'rss');
        $template->replaceAttr('atomLink', 'href', $url->toString());
        $date = Dk_Util_Date::createDate();
        
        foreach ($this->list as $item) {
            $itemRepeat = $template->getRepeat('item');
            $url = new Dk_Util_Url('/');
            $itemRepeat->replaceText('title', $item->getRssTitle());
            $description = str_replace('src="/', 'src="' . $url->toString(), $item->getRssDescr());
            $description = str_replace('href="/', 'href="' . $url->toString(), $description);
            $itemRepeat->replaceText('description', $description);
            $itemRepeat->replaceText('link', $item->getRssLink()->toString());
            if (method_exists($item, 'getCreated')) {
            	$itemRepeat->replaceText('created', $item->getCreated()->toString('r'));
            }else {
            	$itemRepeat->replaceText('created', $date->toString('r'));
            }
            $itemRepeat->append();
        }
        if (count($this->list) > 0) {
            $item = $this->list[0];
            if (method_exists($item, 'getCreated')) {
            	$template->replaceText('now', $item->getCreated()->toString('r'));
            }else {
            	$template->replaceText('now', $date->toString('r'));
            }
        }
        header('Content-type: text/xml');
        echo $template->toString();
        exit;
    }
    
}
?>