<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * The xml webservice result object
 *
 * @package Ws
 */
class Dk_Xml_Result extends Dk_Object 
{
    /**
     * @var DOMDocument
     */
    private $dom = null;
    
    /**
     * @var string
     */
    private $response = '';
    
    /**
     * @var string
     */
    private $responseObject = null;
    
    
    
    /**
     * __construct
     * 
     * @param string $response
     */
    function __construct($response)
    {
        $pos = strpos($response, '<?xml ');
        $this->response = substr($response, $pos);
        $this->dom = self::createDom($this->response);
        $this->responseObject = self::domToStdClass($this->dom->documentElement);
        
    }
    
    
    /**
     * Create a DomDocument object from XML string
     *
     * @param string $xmlStr
     * @return DomDocument
     */
    static function createDom($xmlStr) 
    {
        $dom = new DOMDocument();
        $dom->loadXML($xmlStr);
        if ($dom == null || $dom->documentElement == null) {
            $e = new Dk_Exception("Invalid XML cannot convert XML string to DOM.");
            $e->setDump($xmlStr);
            throw $e;
        }
        return $dom;
    }
    
    /**
     * domToStdClass
     *
     * @param DOMNode $node
     * @return stdClass
     */
    static function domToStdClass(DOMNode $node)
    {
        $node->normalize();
        if ($node->firstChild != null) {
            if ($node->childNodes->length == 1 && $node->firstChild->nodeType == XML_TEXT_NODE) {
                return trim($node->firstChild->nodeValue);
            }
        } else {
            return null;
        }
        $obj = new stdClass();
        $children = $node->childNodes;
        foreach ($children as $child) {
            if ($child->nodeType == XML_ELEMENT_NODE) {
                $property = $child->nodeName;
                $value = self::domToStdClass($child);
                if (isset($obj->$property)) {
                    if (!is_array($obj->$property)) {
                        $tmp = $obj->$property;
                        $obj->$property = array();
                        $obj->{$property}[] = $tmp;
                    }
                    $obj->{$property}[] = $value;
                } else {
                    $obj->$property = $value;
                }
            }
        }
        return $obj;
    }
    
    /**
     * getResponseObj
     *
     * @return stdClass
     */
    function getResponseObj()
    {
        return $this->responseObject;
    }
    
    /**
     * getResponse
     *
     * @return string
     */
    function getResponse() 
    {
        return $this->response;
    }
    
    /**
     * Test if the response is an error
     *
     * @return boolean
     */
    function isError()
    {
        if (isset($this->getResponseObj()->ErrorResponse)) {
            return true;
        }
        return false;
    }
    
    /**
     * getDomResponse
     *
     * @return DOMDocument
     */
    function getDomResponse()
    {
        $dom = new DOMDocument();
        $dom->loadXML($this->response);
        if ($dom != null) {
            return $dom;
        }
    }
    
}
?>