<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * 
 * 
 * @package Ws
 */
class Dk_Xml_Client extends Dk_Object 
{
    /**
     * @var Dk_Util_Url
     */
    private $xmlServiceUrl = null;
    
    /**
     * HTTP Request timeout in secs
     * @var integer
     */
    private $timeout = 15;
    
    
    
    /**
     * __construct
     * 
     * @param Dk_Util_Url $xmlServiceUrl
     */
    function __construct(Dk_Util_Url $xmlServiceUrl)
    {
        $this->xmlServiceUrl = $xmlServiceUrl;
    }
    
    /**
     * Send a request and recive a response from an xml service
     * 
     * @param string $requestBody
     * @param array $headers
     * @return Dk_Xml_Result
     */
    function sendXmlRequest($requestBody, $headers = array())
    {
        $curl = new Dk_Util_Curl();
        $curl->setTimeout($this->timeout);
        $curl->setHeader("Content-type: text/xml; charset=UTF-8");
        foreach ($headers as $v) {
            $v = trim($v);
            if ($v) {
                $curl->setHeader($v);
            }
        }
        $response = $curl->post($this->xmlServiceUrl, $requestBody);
        $result = new Dk_Xml_Result(trim($response));
        return $result;
    }
    
    /**
     * Send a request from a DOM xml document
     * This method assumes the code is in the format:
     * <code>
     *   <?xml version="1.0"?>
     *   <Request>
     *     <PingRequest>...</PingRequest>
     *   </Request>
     * </code>
     * 
     * 
     * @param DOMDocument $doc
     * @param array $headers
     * @return Dk_Xml_Result
     */
    function sendXmlDomRequest(DOMDocument $doc, $headers = array())
    {
        $xmlStr = $doc->saveXML();
        $result = $this->sendXmlRequest($xmlStr, $headers);
        return $result;
    }
    
    /**
     * Set the query timeout in seconds
     *
     * @param integer $i
     */
    function setTimeout($i)
    {
        $this->timeout = intval($i);
    }
}

?>