<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Maps a URI request path to the actual path of the resource or resource producer.
 * 
 * @package Web
 */
class Dk_Web_ResourceMapper 
{
    /**
     * List of resources to look for when the request path is a directory.
     * The mapper will return the first entry that it finds.
     * 
     * @var array
     */
    static $directoryIndex = array('index.html', 'index.php', 'index.htm');
    
    /**
     * @var Dk_Util_Path
     */
    private $baseDir = null;
    
    
    /**
     * 
     * @param Dk_Util_Path $baseDir The resource system base directory.
     */
    function __construct(Dk_Util_Path $baseDir)
    {
        $this->baseDir = $baseDir;
    }

    /**
     * Gets the system resource path.
     * Paths ending in .html are mapped to .php if not found. 
     *
     * @param Sdk_Util_Url $requestUrl The requested url.
     * @return Dk_Util_Path The resource path or null if it cannot be found.
     * @TODO Add extension to have language directories as /sp/ instead of /language/sp/, also alias /en/
     */
    function getResourcePath(Dk_Util_Url $requestUrl)
    {
        $urlPath = urldecode($requestUrl->getPath());
        if (Dk_Util_Url::$pathPrefix != '' && Dk_Util_Url::$pathPrefix != '/') {
            $len = strlen(Dk_Util_Url::$pathPrefix);
            if (substr($urlPath, 0, $len) == Dk_Util_Url::$pathPrefix) {
                $urlPath = substr($urlPath, $len);
            }
        }
        $requestPath = new Dk_Util_Path($this->baseDir->getPath() . $urlPath);
        $resourcePath = null;
        if (!$requestPath->isFile()) {
            $path = $requestPath->getPath();
            if (substr($path, -5) == '.html') {
                $path = substr($path, 0, -5) . '.php';
                $requestPath = new Dk_Util_Path($path);
            } elseif (substr($path, -4) == '.php') {
                $path = substr($path, 0, -4) . '.html';
                $requestPath = new Dk_Util_Path($path);
                if (!$requestPath->isFile()) {
                    $path = substr($path, 0, -5) . '.htm';
                    $requestPath = new Dk_Util_Path($path);
                }
            }
        }
        if ($requestPath->isFile()) {
            switch ($requestPath->getExtension()) {
                case 'txt':
                    break;
                case 'php':
                case 'htm':
                case 'html':
                    $resourcePath = new Dk_Util_Path($requestPath->getPath());
                    break;
                default:
                    break;
            }
        } elseif ($requestPath->isDir()) {
            $strPath = $requestPath->getPath();
            if (substr($strPath, -1) != '/') {
                $strPath .= '/';
            }
            foreach (self::$directoryIndex as $index) {
                $path = new Dk_Util_Path($strPath . $index);
                if ($path->isFile()) {
                    $resourcePath = $path;
                    break;
                }
            }
        }
        
        return $resourcePath;
    }
}
?>
