<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @author Darryl Ross <darryl.ross@aot.com.au>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * For all classes that render dom templates.
 * This is a good base for all renderer objects that implement the Dom_Template
 * it can guide you to create tempaltes that can be inserted into other template
 * objects.
 * 
 * For objects that have a null template when the method getTemplate() is called
 * the magic method __makeTemplate() will be called to create a template automaticaly
 * this is a good place for creating a default template. But be aware that this will 
 * be a new template and will have to be inserted into its parent using the DOMTemplate::insertTemplate()
 * method.
 * 
 * @package Util
 */
abstract class Dk_Web_Renderer extends Dk_Object implements Dom_RendererInterface
{
    
    /**
     * @var Dom_Template
     */
    private $template = null;
    
    
    
    
    /**
     * Set a new template for this renderer.
     * 
     * @param Dom_Template $template
     */
    function setTemplate(Dom_Template $template)
    {
        $this->template = $template;
    }
    
    /**
     * Get the template
     * This method will try to call the magic method __makeTemplate
     * to get a template if non exsits.
     * Use this for object that use internal templates.
     *
     * @return Dom_Template
     */
    function getTemplate() 
    {
        if ($this->template == null && method_exists($this, '__makeTemplate')) {
            $this->template = $this->__makeTemplate();
        }
        return $this->template;
    }
}
?>