<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * 
 * This class is designed to take a DOMDocument, traverse it and pass each Element to 
 * the child Dom iterator. This can be extended by adding DomIteratorInterface objects
 * to the object.
 * 
 * NOTE: Using this will affect page loading performance as it traverses
 *   the entire document.
 * 
 * Example: 
 * <code>
 * <?php
 * 
 * $modifier = new Dk_Web_NodeModifier();
 * $modifier->add(new Sdk_Web_NodeModifierPath());
 * $modifier->execute();
 * 
 * ?>
 * </code>
 * 
 * 
 * @package Web
 */
class Dk_Web_NodeModifier extends Dk_Object implements Dk_Util_ControllerInterface 
{
    /**
     * @var array
     */
    private $modifierList = array();
    
    /**
     * @var DOMDocument
     */
    private $doc = null;
    
    
    
    /**
     * __construct
     * 
     */
    function __construct($doc = null)
    {
    	$this->doc = $doc;
    }
    
    /**
     * Set the DOMDocument to parse.
     * 
     * @param DOMDocument $doc
     */
    function setDocument(DOMDocument $doc)
    {
    	$this->doc = $doc;
    }
    
    /**
     * Enter description here...
     *
     * @param Sdk_Web_DomIteratorInterface $iterator
     */
    function add(Dk_Web_NodeModifierInterface $mod)
    {
        $this->modifierList[] = $mod;
    }
    
    /**
     * Remove a modifier from the execution list
     * 
     */
    function remove(Dk_Web_NodeModifierInterface $mod)
    {
      	foreach ($this->modifierList as $i => $lMod) {
            if ($lMod == $mod) {
                unset($this->modifierList[$i]);
            }
      	}
    }
    
    
    /**
     * Call this method to travers a document
     *
     */
    function execute() 
    {
        if ($this->doc) {
            $this->traverse($this->doc->documentElement);
        }
    }
    
    /**
     * pre init the front controller
     *
     */
    function init() {}
    
    /**
     * Post init the front controller
     * 
     */
    function postInit() {}
    
    /**
     * Traverse a document converting element attributes.
     *
     * @param DOMNode $node
     */
    private function traverse(DOMNode $node) 
    {
        if ($node->nodeType == XML_ELEMENT_NODE) {
    		    /* @var $iterator Dk_Web_NodeModifierInterface */
    		    foreach ($this->modifierList as $mod) {
    		        $mod->executeNode($node);
    		    }
    		    
    		    $children = $node->childNodes;
    		    foreach ($children as $child) {
    		        $this->traverse($child);
    		    }
        }
    }
    
}
?>