<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * This is the base class to all Front Controllers.
 * 
 * 
 * @package Web
 */
abstract class Dk_Web_FrontController implements Dk_Util_ControllerInterface
{
    
    /**
     * Process the request and response of page requested
     * 
     */
    function execute()
    {
        try {
            switch (strtoupper(Dk_Request::getInstance()->getMethod())) {
                case 'GET':
                    $this->doGet();
                    break;
                case 'POST':
                    $this->doPost();
                    break;
                case 'HEAD':
                case 'OPTIONS':
                    break;
                default:
                    error_log("Unknown request method `" . Dk_Request::getInstance()->getMethod() . "`.");
                    break;
            }
        } catch (Exception $e) {
            $this->logFatalError($e);
            $this->showFatalError($e);
        }
        Dk_Response::getInstance()->flushBuffer();
    }
    
    
    
    /**
     * doGet
     * 
     * @throws Dk_Exception
     */
    abstract function doGet();
    
    /**
     * doPost
     * 
     * @throws Dk_Exception
     */
    abstract function doPost();
    
    /**
     * Displays a fatal error message.
     * 
     * @param Exception $e
     * @param Dk_Response $response
     */
    abstract function showFatalError(Exception $e);
    
    /**
     * Log an error 
     *
     * @param Exception $e
     * @TODO check if this is needed?
     */
    private function logFatalError(Exception $e) 
    {    
        $hostname = trim(`/bin/hostname`);
        if (isset($_SERVER['HTTP_HOST'])) {
            $server_info = sprintf('[host (%s) %s client %s] ',
                $_SERVER['HTTP_HOST'], $hostname, $_SERVER['REMOTE_ADDR']);
        } else {
            $server_info = '[CLI: ' . $hostname . '] ';
        }
        
        $msg = '[' . date('D M  j G:i:s Y') . '] Dk-Error: ' . $server_info . "\n" . $e->__toString() . "\n";
        error_log($msg);
    }
}
?>