<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * 
 * 
 * @package Util
 */
class Dk_Util_UrlColumnMap extends Dk_Mapper_ColumnMap 
{
    
    /**
     * The type of property that gets inserted into the object
     * eg: Dk_Mapper_ColumnMap::STRING or an object 'Dk_Util_Date'
     * 
     * @return string
     * @override
     */
    function getPropertyType()
    {
        return 'Dk_Util_Url';
    }

    /**
     * Returns the object property value in its requred property type form from the row.
     * Override this to return the data in its required object form.
     * 
     * @param array $row
     * @return mixed 
     * @override
     */
    function getPropertyValue($row)
    {
        $value = parent::getPropertyValue($row);
        return new Dk_Util_Url($value);
    }
    
    /**
     * Convert the object value to its native php type value 
     * 
     * @param array $row
     * @return integer A php native type (string, integer, float, etc)
     * @override
     */
    function getColumnValue($row)
    {
        $str = null;
        $value = parent::getColumnValue($row);
        if ($value !== null) {
            $value = new Dk_Util_Url($value);
            $str = $value->toString();
        }
        return $str;
    }
    
    
    /**
     * This is a base php serialize type. (Eg: 'integer', 'string' 
     * 
     * @return string
     * @see Dk_Mapper_ColumnMap constant varibles
     * @override
     */
    function getSerialType() 
    {
        return Dk_Db_ColumnMap::CM_STRING;
    }
    
    /**
     * Get the property name of where the value is stored in the serialized object
     * 
     * @return string
     * @override
     */
    function getSerialName() 
    {
        return 'spec';
    }
    
    /**
     * Get the native type for the property ready for serialization
     * 
     * @param array $row
     * @return mixed A php native type (string, integer, float, etc)
     * @override
     */
    function getSerialValue($row) 
    {
        $value = parent::getSerialValue($row);
        if ($value !== null) {
            return $value;
        }
    }
}
?>
