<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A class that can carry out Linux system commands.
 *
 * Note: In order for this to work you must have ssh
 * rsa keys on both systems to avoid the password prompt.
 * 
 * @package Util
 * @deprecated Use Dk_Util_Exec Will be removed in V3.0
 */
class Dk_Util_Shell {

    
    /**
     * scp from the dev derver to a remote server.
     * 
     * @param String $host 
     * @param String $dst 
     * @param String $file 
     */
    function scp($srcFile, $dstFile)
    {
        try {
            $msg = Dk_Util_Exec::scp($srcFile, $dstFile);
        } catch (Exception $e) {}
        return $msg;
    }
    
    /**
     * Execute commands on a remote server using ssh.
     * 
     * Note: In order for this to work you must have ssh
     *   rsa keys (private/public) on both systems to avoid the password prompt.
     * 
     *  Command: ssh-keygen -t rsa
     * 
     * The private key would reside in the webserver user ~/.ssh/id_rsa file and 
     * the public key would reside in the $sshUser ~/.ssh/authorized_keys file
     *  
     * @param string $cmd
     * @param string $sshUser
     * @param string $sshServer
     * @return String
     */
    function remoteSystem($cmd, $sshUser, $sshServer)
    {
        try {
            $msg = Dk_Util_Exec::sshExec($cmd, $sshUser, $sshServer);
        } catch (Exception $e) {}
        return $msg;
    }
    
    /**
     * Wrapper for the exe() command
     * 
     * @param string $cmd
     * @return string
     * @throws RuntimeException
     */
    function system($cmd)
    {
        try {
            $msg = Dk_Util_Exec::exec($cmd);
        } catch (Exception $e) {}
        return $msg;
    }
    
}
?>