<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * 
 * @package Util
 */
class Dk_Util_MoneyField extends Dk_Form_Field 
{
    
    
    /**
     * Loads the object and the form fields from the request.
     * 
     * @param array $array
     * @return Dk_Util_Money
     */
    function loadFromArray($array)
    {
        $name = $this->getName();
        
        $this->domValues[$name] = $array[$name];
        $money = Dk_Util_Money::parseFromString($array[$name]);
        if ($money == null) {
            $money = new Dk_Util_Money(0);
        }
        $this->setValueFromRequest($money);
    }
    
    
    /**
     * Get this field's string values.
     *
     * @param Dk_Util_Money $value
     */
    function setDomValues($value) 
    {
        if ($value == null) {
            $this->domValues->put($this->getName(), '');
        } else {
            $amount = $value->toFloatString();
            $this->domValues[$this->getName()] = $amount;
        }
    }
    
}
?>