<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @author Darryl Ross <darryl.ross@aot.com.au>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * The LOO object is named from the params (Limit, Offset, OrderBy)
 * This object manages the list params such as $orderBy, $limit and $offset
 * These params are used by lists and Ui elements throughout the Dk
 * 
 * @package Util
 */
class Dk_Util_Loo extends Dk_Object  
{
    const LIMIT = 'limit';
    const OFFSET = 'offset';
    const ORDER_BY = 'orderBy';
    
    /**
     * @var integer
     */
    private $limit = 50;
    
    /**
     * @var integer
     */
    private $offset = 0;
    
    /**
     * @var string
     */
    private $orderBy = '`id` DESC';
    
    
    
    /**
     * __construct
     * 
     * @param integer $limit
     * @param integer $offset
     * @param string $orderBy
     */
    function __construct($limit = 0, $offset = 0, $orderBy = '')
    {
        $this->limit = intval($limit);
        $this->offset = intval($offset);
        $this->orderBy = Dk_Db_MyDao::escapeString($orderBy);
    }
    
    /**
     * Create a listParams object from a request object
     * 
     * @param integer $comId This is used to create the request keys for the parameters
     * @param string $orderBy The default orderby to use
     * @return Dk_Util_Loo
     */
    static function createFromRequest($comId = null, $orderBy = '`id` DESC')
    {
        $request = Dk_Request::getInstance();
        $append = '';
        if ($comId) {
            $append = '_' . $comId;
        }
        $limit = 50;
        
        if ($request->exists(self::LIMIT . $append)) {
            $limit = intval($request->getParameter(self::LIMIT . $append)); 
        }
        $offset = intval($request->getParameter(self::OFFSET . $append));
        if ($request->exists(self::ORDER_BY . $append)) {
            $orderBy = Dk_Db_MyDao::escapeString($request->getParameter(self::ORDER_BY . $append)); 
        }
        
        return new self($limit, $offset, $orderBy);
    }
    
    /**
     * Set the order By value
     *
     * @param string $str
     */
    function setOrderBy($str)
    {
        $this->orderBy = $str;
    }
    
    /**
     * Get the order by string for the DB queries
     *
     * @return string
     */
    function getOrderBy()
    {
        return $this->orderBy;
    }
    
    /**
     * Set the limit value
     *
     * @param integer $i
     */
    function setLimit($i)
    {
        $this->limit = $i;
    }
    
    /**
     * Get the page limit for pagenators and queries
     * 
     * @return integer
     */
    function getLimit()
    {
        return $this->limit;
    }
    
    /**
     * Set the offset value
     *
     * @param integer $i
     */
    function setOffset($i)
    {
        $this->offset = $i;
    }
    
    /**
     * Get the record offset for pagenators and queries
     *
     * @return integer
     */
    function getOffset()
    {
        return $this->offset;
    }
    
}
?>