<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A class that can carry out Linux system commands.
 *
 * Note: In order for this to work you must have ssh
 * rsa keys on both systems to avoid the password prompt.
 * 
 * 
 * @package Util
 */
class Dk_Util_Exec
{
    
    
    /**
     * scp from the dev derver to a remote server.
     * 
     * @param String $host 
     * @param String $dst 
     * @param String $file 
     * @throws RuntimeException
     */
    static function scp($srcFile, $dstFile)
    {
        $cmd = sprintf("scp %s %s", 
                        escapeshellcmd($srcFile),
                        escapeshellcmd($dstFile));
        
        return self::system($cmd);
    }
    
    /**
     * Execute commands on a remote server using ssh.
     * 
     * Note: In order for this to work you must have ssh
     *   rsa keys (private/public) on both systems to avoid the password prompt.
     * 
     *  Command: ssh-keygen -t rsa
     * 
     * The private key would reside in the webserver user ~/.ssh/id_rsa file and 
     * the public key would reside in the $sshUser ~/.ssh/authorized_keys file
     *  
     * @param string $cmd
     * @param string $sshUser
     * @param string $sshServer
     * @return String
     * @throws RuntimeException
     */
    static function sshExec($cmd, $sshUser, $sshServer)
    {
        $error = 0;
        $return = '';
        $sshCmd = sprintf("ssh %s@%s \"%s\" 2>&1", escapeshellcmd($sshUser), escapeshellcmd($sshServer), $cmd);
        exec($sshCmd, $return, $error);
        $return = implode("\n", $return);
        if ($error) {
            throw new RuntimeException($return);
        }
        return $return;
    }
    
    /**
     * Wrapper for the exe() command
     * 
     * @param string $cmd
     * @return string
     * @throws RuntimeException
     */
    static function exec($cmd)
    {
        $error = 0;
        $return = '';
        exec($cmd . ' 2>&1', $return, $error);
        $return = implode("\n", $return);
        if ($error) {
            throw new RuntimeException($return);
        }
        return $return;
    }
    
}
?>