<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * An object to handle string encryption based on a key
 *
 * @package Util
 */
class Dk_Util_Encrypt extends Dk_Object 
{
    /**
     * The default key if none entered
     * @var string
     */
    static $key = '@@_Default_DK_@@';
    
    
    /**
     *  encrypt
     *
     * @param string $string
     * @param string $key
     */
    static function encrypt($string, $key = '') 
    {
        if ($key == '') {
            $key = self::$key;
        }
        $result = '';
        for($i=0; $i<strlen($string); $i++) {
          $char = substr($string, $i, 1);
          $keychar = substr($key, ($i % strlen($key))-1, 1);
          $char = chr(ord($char)+ord($keychar));
          $result .= $char;
        }
        return base64_encode($result);
    }
    
    
    /**
     * decrypt
     *
     * @param string $string
     * @param string $key
     */
    static function decrypt($string, $key = '') 
    {
        if ($key == '') {
            $key = self::$key;
        }
        $result = '';
        $string = base64_decode($string);
        for($i=0; $i<strlen($string); $i++) {
          $char = substr($string, $i, 1);
          $keychar = substr($key, ($i % strlen($key))-1, 1);
          $char = chr(ord($char)-ord($keychar));
          $result .= $char;
        }
        return $result;
    }
  
}
?>