<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * An interface for an object to return its data path.
 * This is usually the path in the data directory that
 * the object is storing its uploaded media to.
 * This can be used for large object to ensure the object's data
 * is allways stored in the same directory.
 * 
 * NOTE: All paths returned must be relative from the site FileRoot
 * the site file root path can be added during access. This allows for portability
 * between the Dk_Util_Path and Dk_Util_Url objects.
 * 
 * @package Form
 */
interface Dk_Util_DataPathInterface
{
    
    /**
     * Get the object data path relative to the site file root
     * For a standard data file the path might be: `/data/files/thumbs`
     * 
     * @return Dk_Util_Path
     */
    function getDataPath();
    
}
?>