<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * 
 * @package Util
 */
class Dk_Util_CurrencyField extends Dk_Form_Field 
{
    
    
    /**
     * Loads the object and the form fields from the request.
     *
     * @param array $array
     * @return Dk_Util_Currency
     */
    function loadFromArray($array)
    {
        $name = $this->getName();
        
        $domValue = $array[$name];
        $this->domValues[$name] = $domValue;
        
        $currency = Dk_Util_Currency::getInstance($domValue);
        if ($currency == null) {
            $currency = Dk_Util_Currency::getInstance();
        }
        $this->setValueFromRequest($currency);
    }
    
    
    /**
     * Get this field's string values.
     *
     * @param Dk_Util_Currency $value
     */
    function setDomValues($value) 
    {
        if ($value == null) {
            $this->domValues[$this->getName()] = '';
        } else {
            $currencyCode = $value->getCurrencyCode();
            $this->domValues[$this->getName()] = $currencyCode;
        }
    }
    
}
?>