<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * A Wdk config object.
 * 
 * @package Util
 */
class Dk_Util_CrumbStack 
{
    const CRUMB_SID = '__widgetCrumbs';
    const CRUMB_VAR = '__crumbs';

    /**
     * @var Dk_Util_CrumbStack
     */
    static protected $instance = null;
    
    /**
     * @var array
     */
    private $crumbs = array();
    
    
    
    /**
     * Sigleton, No instances can be created.
     * Use:
     *   Dk_Util_CrumbStack::getInstance()
     */
    private function __construct() { }
    
    
    
    /**
     * Get an instance of this object
     * 
     * @return Dk_Util_CrumbStack
     */
    static function getInstance() 
    {
        if (self::$instance == null) {
            $session = Dk_Session::getInstance();
            if ($session->getParameter(self::CRUMB_SID) instanceof Dk_Util_CrumbStack) {
                self::$instance = $session->getParameter(self::CRUMB_SID);
            } else {
                self::$instance = new Dk_Util_CrumbStack();
                $session->setParameter(self::CRUMB_SID, self::$instance);
            }
        }
        return self::$instance;
    }
    
    /**
     * Initalise a component for use with the crumbsStack
     *
     * @param Dk_Web_Component $com
     */
    function init(Dk_Web_Component $com)
    {
        if (ereg('/admin/index.html$', Dk_Request::getInstance()->getRequestUri()->getPath())) {
            $this->reset();
        }
        if ($com->getParent() != $com->getPage()) {
            return;
        }
        $this->trim(Dk_Request::getInstance()->getRequestUri());
        $pageTemplate = $com->getPage()->getTemplate(); 
        if ($pageTemplate->keyExists('var', self::CRUMB_VAR)) {
            if ($this->size() > 0) {
                $pageTemplate->setChoice(self::CRUMB_VAR);
                $pageTemplate->replaceHTML(self::CRUMB_VAR, $this->getListHtml());
                $current = $this->getCurrent();
                if ($current) {
                    $com->getTemplate()->replaceAttr('__back', 'href', $current->toString());
                    $pageTemplate->replaceAttr('__back', 'href', $current->toString());
                }
            }
        }
    }
    
    
    /**
     * Put a url obto the bread crumb stack
     *
     * @param Dk_Util_Url $url
     * @param String $name
     */
    function putUrl(Dk_Util_Url $url, $name = '')
    {
        if ($name == null) { // get name from the file
            $name = basename($url->getPath());
            $pos = strrpos($name, '.');
            if ($pos) {
                $name = substr($name, $pos+1);
                $name = trim(preg_replace('/[A-Z]/',  ' $0', ucfirst($name)));
            }
        }
        if (array_key_exists($name, $this->crumbs)) {
            $newArr = array();
            foreach ($this->crumbs as $cName => $cUrl) {
                if ($cName == $name) {
                    break;
                }
                $newArr[$cName] = $cUrl;
            }
            $this->crumbs = $newArr;
        }
        $this->crumbs[$name] = $url;
    }
    
    /**
     * Return the crumb based on the name if it exists
     *
     * @param string $name
     * @return Dk_Util_Url
     */
    function getCrumb($name)
    {
        return $this->crumbs[$name];
    }
    
    /**
     * Get the topmost url 
     *
     * @return Dk_Util_Url
     */
    function getCurrent()
    {
        $keys = array_keys($this->crumbs);
        return $this->getCrumb($keys[count($keys)-1]);
    }
    
    /**
     * reset the crumb stack.
     *
     */
    function reset()
    {
        $this->crumbs = array();
    }
    
    /**
     * trim the stack back to the requested Url
     *
     */
    function trim(Dk_Util_Url $url)
    {
        $newArr = array();
        foreach ($this->crumbs as $cName => $cUrl) {
            if ($url->getBasename() == $cUrl->getBasename()) {
                break;
            }
            $newArr[$cName] = $cUrl;
        }
        $this->crumbs = $newArr;
    }
    
    /**
     * get the size of the crumbs array
     *
     * @return integer
     */
    function size()
    {
        return count($this->crumbs);
    }
    
    /**
     * Get an HTML unorderd list of the crumbs
     * 
     * @return string
     */
    function getListHtml()
    {
        if ($this->size() == 0) {
            return '';
        }
        $html = '';
        $i = 0;
        foreach ($this->crumbs as $name => $url) {
            $sep = '';
            if ($i < count($this->crumbs)-1) {
                $sep = ' <span>&#187;</span> ';
            }
            $html .= sprintf('<li><a href="%s" title="%s">%s</a>%s</li>%s', $url->toString(), $name, $name, $sep, "\n");
            $i++;
        }
        return "<ul>\n" . $html . "</ul>\n";
    }
    
    /**
     * Get the hash of the current crumb trail
     *
     * @return string
     */
    function getHash()
    {
        $str = '';
        foreach ($this->crumbs as $name => $url) {
            $str .= $name;
        }
        return md5($str);
    }
}
?>