<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A controller interface for objects that are 
 * the main controllers of their individual sub-systems.
 * 
 * @package Dk
 */
interface Dk_Util_ControllerInterface
{
    
    /**
     * Do all pre-initalisation operations
     * This method called before the execution method
     *
     */
    function init();

    /**
     * Execute the controller
     * 
     */
    function execute();
    
    /**
     * Do all post initalisation operations here
     * This method called after the execute method
     * 
     */
    function postInit();
	
	
}
?>