<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Dk_User_Login
 * 
 * 
 * @package Widgets
 */
class Dk_User_Login extends Dk_Web_Component  
{
    
    /**
     * __construct
     * 
     */
    function __construct() 
    {
        parent::__construct();
        
        $this->addEvent('login', 'doLogin');
        $this->addEvent('logout', 'doLogout');
    }
    
    /**
     * Enter description here...
     *
     * @return Dk_Web_Template
     */
    function __makeTemplate()
    {
        $html = '<?xml version="1.0" encoding="UTF-8"?>
<div class="Login">
    
  <ul choice="logout" class="logout">
    <li><a href="#" var="userUrl">My Account</a></li>
    <li><a href="#" var="logoutUrl">Logout</a></li>
  </ul>
    
  <form id="_Login" method="post">
    <div choice="login">
      <p class="error" choice="form-error" var="form-error" />
      <p class="error" choice="username-error" var="username-error" />
      <p class="error" choice="password-error" var="password-error" />
      <div>
        <label for="fid-username">Username:</label>
        <input type="text" name="username" id="fid-username" size="10"/>
      </div>
      <div>
        <label for="fid-password">Password:</label>
        <input type="password" name="password" id="fid-password" size="10" />
      </div>
      <div choice="remember">
        <label for="fid-remember">Remember Me:</label>
        <input type="checkbox" name="remember" value="remember" id="fid-remember" />
      </div>
      <div class="submit">
        <input type="submit" name="login" value="Login" />
      </div>
    </div>
    <div class="clear"></div>
    
  </form>
</div>';
        return Dk_Web_Template::loadXml($html);
    }
    
    /**
     * init
     *
     */
    function init()
    {
        //$template = $this->getTemplate();
        $form = new Dk_Form_Object('_Login');
        $form->addField('username');
        $form->addField('password');
        $form->addField('remember', Dk_Form_Object::TYPE_BOOLEAN);
        $this->setForm($form);
        
    }
    
    /**
     * process
     * 
     */
    function doDefault()
    {
    }
    
    /**
     * Find a user in the system
     *
     * @param string $username
     * @return Dk_User_Interface
     */
    function findUser($username)
    {
        $class = $this->getAuth()->getUserClass();
        return eval('return '.$class."::findByUsername('$username');");
    }
    
    
    /**
     * doLogin
     *
     */
    function doLogin()
    {
        $request = $this->getRequest();
        
        if ($this->getAuth() == null) {
            throw new Dk_Exception('No Authorisation Object Registered.');
        }
        $this->getForm()->loadFromRequest($request);
        
        
        $username = $this->cleanString($this->getForm()->getFieldValue('username')); 
        $password = $this->cleanString($this->getForm()->getFieldValue('password'));
        if(!ereg("[a-zA-Z0-9_@ \.-]+", $username)) {
            $username = '';
            $this->getForm()->addFieldError('username', 'Invalid Username.');
        }
        if(!ereg("[a-zA-Z0-9_@ \.-]+", $password)) {
            $password = '';
            $this->getForm()->addFieldError('password', 'Invalid Password.');
        }
        
        if ($this->getForm()->hasErrors()) {
            return;
        }
        // Find the logged in user
        $user = $this->findUser($username);
            
        if ($user != null) {
            $this->getAuth()->setUser($user);
            if ($this->getAuth()->getHashFunction()) {
                $func = $this->getAuth()->getHashFunction();
                $password = $func($password);
            }
            if ($this->getAuth()->isAuthentic($password)) {
                $this->loginCallback($user);
            } else {
                $this->getAuth()->setUser(null);
                $this->getForm()->addFieldError('password', 'Invalid Password.');
            }
        } else {
            $this->getForm()->addFieldError('username', 'Invalid Username.');
        }
    }
    
    /**
     * doLogout
     *
     */
    function doLogout()
    {
        $this->getAuth()->setUser(null);
        $this->logoutCallback();
    }
    
    
    

    /**
     * Render
     *
     */
    function show($template = null) 
    {
        
        if ($this->getAuth()->getUser() != null) {
            $template->replaceText('username', $this->getForm()->getField('username'));

            $user = $this->getAuth()->getUser();
            
            $url = $user->getHomeUrl();
            $template->replaceAttr('userUrl', 'href', $url->toString());
            $template->replaceAttr('userBtn', 'onclick', "document.location = '" . $url->toString() . "'");
            $this->getPage()->getTemplate()->replaceAttr('_userHomeUrl', 'href', $url->toString());
            
            $url = Dk_Request::getInstance()->getRequestUri();
            $url->setQueryField('logout', 'logout');
            
            $template->replaceAttr('logoutUrl', 'href', $url->toString());
            $template->replaceAttr('logoutBtn', 'onclick', "document.location = '" . $url->toString() . "'");
            $this->getPage()->getTemplate()->replaceAttr('_logoutUrl', 'href', $url->toString());

            $template->setChoice('logout');
            $this->getPage()->getTemplate()->setChoice('_logout');
            $this->getPage()->getTemplate()->replaceText('_loginHeading', 'Logout');
        } else {
            $template->setChoice('login');
            $this->getPage()->getTemplate()->setChoice('_login');
            $this->getPage()->getTemplate()->replaceText('_loginHeading', 'Login');
        }
    }
    
    
    
    
    /**
     * Called after a successful login.
     *
     * @param Dk_User_Interface $user
     */
    function loginCallback(Dk_User_Interface $user) 
    {
        $url = $user->getHomeUrl();
        $url->redirect();
    }
    
    /**
     * Called before a logout.
     * 
     */
    function logoutCallback()
    {
        $url = new Dk_Util_Url('/index.html');
        $url->redirect();
    }
    
    
    /**
     * A function to clean a username and a password.
     * 
     * The only valid charcters are: ^a-zA-Z0-9_@.- and a space ' '
     * A space is only valid inside other text and not at the ends, trim gets rid of these.
     *
     * @param string $str
     * @return string
     */
    function cleanString($str)
    {
        $str = trim($str);
        return ereg_replace("[^a-zA-Z0-9_@ \.-]+", "", $str);
    }
    
    
    /**
     * Get the Auth Object
     * 
     * @return Dk_User_Auth
     */
    function getAuth()
    {
        return Dk_User_Auth::getInstance();
    }
}
?>