<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * An user object interface, to be used with the Auth object.
 * 
 * @package User
 */
interface Dk_User_Interface
{
    
    /**
     * Loacate a user from a defined source
     * 
     * @param string $username
     * @return Dk_User_Interface
     */
    static function findByUsername($username);
    
    /**
     * Get the username
     *
     * @return string
     */
    public function getUsername();
    
    /**
     * Get the password
     * This can be pain text or MD% depending on the auth configuration
     *
     * @return string
     */
    public function getPassword();
    
    /**
     * Get this users group ID
     * 
     * @return integer
     */
    public function getGroupId();
    
    /**
     * Get the Home page for this user
     *
     * @return Dk_Util_Url
     */
    public function getHomeUrl();
    
}
?>