<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * Render an array of Dk objects to a table
 * This cell uses the event keys:
 *  o doOrder   - This is the order direction 'up' or 'down'
 *  o doOrderId - This is the object id to move 
 * 
 * @package Ui
 */
class Dk_Ui_Table_OrderByCell extends Dk_Ui_Table_Cell 
{
    /**
     * Get the object pos in the array by its id
     *
     * @param integer $id
     * @return integer
     */
    function getObjectPos($id)
    {
        foreach ($this->getTable()->getList() as $i => $obj) {
            if ($obj->getId() == $id) {
                return $i;
            }
        }
        return -1;
    }
    
    
    function doProcess()
    {
        
        if (Dk_Request::getInstance()->exists($this->getEventKey('doOrder')) && Dk_Request::getInstance()->exists($this->getEventKey('doOrderId'))) {
            $id = intval(Dk_Request::getInstance()->getParameter($this->getEventKey('doOrderId')));
            $order = Dk_Request::getInstance()->getParameter($this->getEventKey('doOrder'));
            $pos = $this->getObjectPos($id);
            $list = $this->getTable()->getList();
            $swapObj = null;
            if ($pos >= 0) {
                $obj = $list[$pos];
                
                if ($order == 'up' && $pos-1 >= 0) {
                    $swapObj = $list[$pos-1];
                } else if ($order == 'dn' && $pos+1 < $list->count()) {
                    $swapObj = $list[$pos+1];
                }
                if ($obj != null && $swapObj != null) {
                    $mapper = Dk_Db_ObjectFactory::getDbMapper($obj);
                    $mapper->orderSwap($obj, $swapObj);
                }
            }
        
            $url = Dk_Request::getInstance()->getRequestUri();
            $url->removeQueryField($this->getEventKey('doOrder'));
            $url->removeQueryField($this->getEventKey('doOrderId'));
            $url->redirect();
        }
        
    }

    
    /**
     * Get the table data from an object if available
     * 
     * @param Dk_Db_Object $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        $urlUp = Dk_Request::getInstance()->getRequestUri();
        $urlUp->setQueryField($this->getEventKey('doOrder'), 'up');
        $urlUp->setQueryField($this->getEventKey('doOrderId'), $obj->getId());
        
        $urlDn = Dk_Request::getInstance()->getRequestUri();
        $urlDn->setQueryField($this->getEventKey('doOrder'), 'dn');
        $urlDn->setQueryField($this->getEventKey('doOrderId'), $obj->getId());
        
        return sprintf('<a href="%s" title="Move Order Up" rel="nofollow"><img src="/images/icons/16/order_up.png" /></a> <a href="%s" title="Move Order Down" rel="nofollow"><img src="/images/icons/16/order_down.png" /></a>',
            htmlentities($urlUp->toString()), htmlentities($urlDn->toString()));
    }
    
    
}
?>