<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Dk_Ui_Table_IntegerCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * get the parameter data from an object if available
     *
     * @param Dk_Object $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        $str = 0 . '';
        $method = $this->getMethod($obj);
        if ($method) {
            $str = $obj->$method() . '';
        }
        return $str;
    }
    
    
}
?>