<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Dk_Ui_Table_DeleteAction extends Dk_Ui_Table_Action
{
    
    function doProcess()
    {
        if (Dk_Request::getInstance()->exists($this->getEventKey('delete'))) {
            $this->doDelete();
        }
    }
    
    function doDelete()
    {
        $selected = Dk_Request::getInstance()->getParameterValues($this->getEventKey('cb'));
        if (count($selected)) {
            foreach ($this->table->getList() as $obj) {
                if (!$obj instanceof Dk_Db_Object) {
                    continue;
                }
                if (in_array($obj->getId(), $selected)) {
                    $obj->delete();
                }
            }
        } 
        
        $url = Dk_Request::getInstance()->getRequestUri();
        $url->removeQueryField($this->getEventKey('cb'));
        $url->redirect();
    }
}
?>