<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Dk_Ui_Table_ActionUrl extends Dk_Ui_Table_ActionInterface
{
    
    /**
     * @var Dk_Util_Url
     */
    protected $url = null;
    
    /**
     * @var string
     */
    protected $text = '';
    
    /**
     * @var string
     */
    protected $class = 'group';
    
    /**
     * @var string
     */
    protected $confirm = '';
    
    
    /**
     * Create the object instance
     *  
     * @param Dk_Util_Url $url
     * @param string $text
     * @param string $class
     * @param string $confirm
     * @see css files for more class options
     */
    function __construct($url, $text, $class = '', $confirm = '') 
    {
        $this->url = $url;
        $this->text = $text;
        $this->class = $class;
        $this->confirm = $confirm;
    }
    
    /**
     * Get the action HTML to insert into the Table
     * 
     * @return string
     */
    function getHtml()
    {
        $js = '';
        if ($this->confirm) {
            $js = sprintf("return confirm('%s');", $this->confirm);
        }
        
        return sprintf('<a class="%s" href="%s" onclick="%s" title="%s">%s</a>',
            $this->class, htmlentities($this->url->toString()), $js, $this->text, $this->text);
    }
    
    
}
?>