<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/** 
 * The interface to allow actions and filters to be added to a table
 * 
 * @package Ui
 */
abstract class Dk_Ui_Table_ActionInterface extends Dk_Ui_Table_ExtraInterface
{
    
    
    /**
     * Get the form id so we can use the javascript setForm(id, event); function
     * 
     * @return string $id
     */
    function getFormId()
    {
        return $this->table->getFormId();
    }
    
    /**
     * Setup any form fields for this acion
     *
     * @param Dk_Form_Object $form
     * @return Dk_Form_Object
     */
    function setFormFields(Dk_Form_Object $form) { return $form; }
    
    
    /**
     * Get the filter HTML to insert into the Table
     * 
     * @return string
     */
    abstract function getHtml();
    
    
    
}
?>