<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Populate a select element with the user names
 * 
 * @package Ui
 */
abstract class Dk_Ui_Select extends Dk_Web_Renderer 
{
    /**
     * @var Dom_FormSelect
     */
    private $select = null;
    
    /**
     * @var array
     */
    private $options = array();
    
    
    
    /**
     * __construct
     *
     * @param Dom_FormSelect $select
     */
    function __construct(Dom_FormSelect $select)
    {
        $this->select = $select;
        $this->setTemplate($select->getTemplate());
    }

    
    
    /**
     * Render
     *
     */
    function show($template = null)
    {
        $this->init();
        foreach ($this->options as $k => $v) {
            $this->select->appendOption($k, $v);
        }
    }
    
    /**
     * init the options array
     */
    abstract function init();
        
    

    /**
     * Add an option to the select box
     *
     * @param string $name
     * @param string $value
     */
    function addOption($name, $value = '')
    {
        if ($value == null) {
            $value = $name;
        }
        $this->options[$name] = $value;
    }
    
    /**
     * Get the form select element
     *
     * @return Dom_FormSelect
     */
    function getSelect() 
    {
        return $this->select;
    }
}
?>