<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A component to render the results pager data...
 * 
 * 
 * @package Ui
 */
class Dk_Ui_Results extends Dk_Web_Component
{
    /**
     * @var integer
     */
    private $size = 0;
    
    /**
     * @var integer
     */
    private $limit = 0;
    
    /**
     * @var integer
     */
    private $offset = 0;
    
    
    
    /**
     * Create the object instance
     * 
     * @param integer $size
     * @param integer $limit
     * @param integer $offset
     */
    function __construct($size = 0, $limit = 25, $offset = 0) 
    {
        $this->size   = intval($size);
        $this->limit  = intval($limit);
        $this->offset = intval($offset);
        parent::__construct();
    }
    
    
    /**
     * Make a results object from a db list
     * 
     * @return Dk_Ui_Results
     */
    static function makeFromList(Dk_Db_Array $list)
    {
        return new self($list->getTotal(), $list->getLoo()->getLimit(), $list->getLoo()->getOffset());
    }
    
    /**
     * makeTemplate
     *
     * @return string
     */
    protected function __makeTemplate()
    {
        $xmlStr = '<?xml version="1.0"?>
<div class="Dk_Ui_Results">
  <span var="from"></span> -
  <span var="to"></span> records of
  <span var="total"></span> total
</div>';
        $template = Dk_Web_Template::loadXml($xmlStr);
        return $template;
    }
    
    /**
     * Render the widget.
     * 
     */
    function show($template = null) 
    {
        $template->replaceText('from', $this->offset + 1);
        $to = $this->offset + $this->limit;
        if ($to > $this->size) {
            $to = $this->size;
        }
        $template->replaceText('to', $to);
        $template->replaceText('total', $this->size);
    }
}
?>