<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A Limit component allows the user to change the number of records per page.
 * 
 * 
 * @package Ui
 */
class Dk_Ui_Limit extends Dk_Web_Component
{
    
    /**
     * @var integer
     */
    private $limit = 50;
    
    /**
     * @var integer[]
     */
    private $limits = array();
    
    
    
    /**
     * Create the object instance
     *
     * @param integer[] $limits
     */
    function __construct($limit = 50, $limits = array(10, 25, 50, 100)) 
    {
        $this->limit = $limit;
        $this->limits = $limits;
        parent::__construct();
    }
    
    /**
     * Make a limit from a db list
     * 
     * @return Dk_Ui_Limit
     */
    static function makeFromList(Dk_Db_Array $list, $limits = array(10, 25, 50, 100))
    {
        return new self($list->getLoo()->getLimit(), $limits);
    }
    
    /**
     * Set this ID same as the parent component ID
     *
     * @param Dk_Web_Component $component
     */
    protected function setParent(Dk_Web_Component $component)
    {
        $this->id = $component->getId();
        parent::setParent($component);
    }
    
    /**
     * makeTemplate
     *
     * @return string
     */
    protected function __makeTemplate()
    {
        $xmlStr = '<?xml version="1.0"?>
<ul class="Dk_Ui_Limit" choice="Dk_Ui_Limit">
  <li class="show">Records per page:</li>
  <li repeat="row" var="row"><a href="javascript:;" var="limit" rel="nofollow">10</a></li>
</ul>';
        $template = Dk_Web_Template::loadXml($xmlStr);
        return $template;
    }
    
    /**
     * init
     *
     */
    function init()
    {
        
        
        
    }
    
    /**
     * Render the widget.
     * 
     */
    function show($template = null) 
    {
        if (count($this->limits) <= 0) {
            return;
        }
        $template->setChoice('Dk_Ui_Limit');
        
        $pageUrl = Dk_Request::getInstance()->getRequestUri();
        $pageUrl->removeQueryField($this->getEventKey('limit'));
        foreach ($this->limits as $limit) {
            $repeat = $template->getRepeat('row');
            $pageUrl->setQueryField($this->getEventKey('limit'), $limit);
            $repeat->replaceText('limit', $limit);
            $repeat->replaceAttr('limit', 'href', $pageUrl->toString());
            if ($limit == $this->limit) {
                $repeat->replaceAttr('row', 'class', 'selected');
            }
            $repeat->append();
        }
    }
    
}
?>