<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Display a processing Icon while dissabling the page so no input can take place
 * 
 * 
 * 
 * @package Ui
 */
class Dk_Ui_LightBox_Processing extends Dk_Ui_LightBox_Object
{
    
    
    /**
     * Create the swf companent.
     * 
     * @param Dk_Util_Url $backgroundImg
     * @param Dk_Util_Url $loadingImg
     */
    function __construct($backgroundImg = null, $loadingImg = null)
    {
        
        if (!$backgroundImg) {
            $backgroundImg = new Dk_Util_Url('/lib/Dk/Ui/LightBox/images/background.gif');
        }
        if (!$loadingImg) {
            $loadingImg = new Dk_Util_Url('/lib/Dk/Ui/LightBox/images/icon1.gif');
        }
        
        $html = sprintf('<div class="processing"><img src="%s" alt="" />Loading... </div>', $loadingImg->toString());
        parent::__construct($html, 250, 100, $backgroundImg);
        $this->hideHead(true);
    }
    
    
}
?>
