<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Populate a select element with the values from an array
 * 
 * The array: array(1 => 'Item 1', 2 => 'Item 2');<br/>
 * The result: <select><option value="1">Item 1</option><option value="2">Item 2</option></select>
 * 
 * @package Ui
 */
final class Dk_Ui_ArraySelect extends Dk_Ui_Select 
{
    private $array = array();
    
    /**
     * __construct
     *
     * @param Dom_FormSelect $select
     * @param array $arrays 
     */
    function __construct(Dom_FormSelect $select, $array)
    {
        parent::__construct($select);
        $this->array = $array;
    }
    
    /**
     * init the options array
     */
    function init()
    {
        foreach ($this->array as $k => $v) {
            $this->addOption($v, $k);
        }
    }

}
?>