<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A session object
 * 
 * @package Dk
 */
class Dk_Session extends Dk_Object
{
    
    /**
     * @var Dk_Session
     */
    static protected $instance = null;
    
    
    /**
     * This is a singleton class, use getInstance();
     * 
     */
    private function __construct($name = 'PHPSESSID') 
    {
        if (isset($_SESSION)) {
            session_write_close();
        }
        session_name($name);
        if (isset($_REQUEST[$name]) && isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == 'on') {
            session_id($_REQUEST[$name]);
        }
        session_start();
    }
    
    /**
     * Get an instance of this object
     * 
     * @param string $name if not null a new session is started with the new name
     * @return Dk_Session
     */
    static function getInstance($name = '') 
    {
        if (self::$instance == null || $name != '') {
            if ($name == null) {
                $name = 'PHPSESSID';
            }
            self::$instance = new Dk_Session($name);
        }
        return self::$instance;
    }
    
    
    
    /**
     * Clears the session of all registered variables.
     * 
     */
    function clear() 
    {
        session_destroy();
    }
    
    /**
     * Binds data to this session, using the name specified.
     *
     * @param string $name A key to retrieve the data
     * @param mixed $value 
     */
    function setParameter($name, $value)
    {
        if ($value === null) {
            $this->removeParameter($name);
        } else {
            $_SESSION[$name] = $value;
        }
    }
    
    /**
     * Returns the data bound with the specified name in this session, 
     * or null if data is bound under the name.
     *
     * @param string $name The key to retrieve the data.
     * @return mixed 
     */
    function getParameter($name)
    {
      if (isset($_SESSION[$name])) {
            $value = $_SESSION[$name];
      } else {
          $value = null;
      }
      return $value;
    }
  
    /**
     * Unset an element from the session
     * 
     * @param string $key
     */
    function removeParameter($key) 
    {
        unset($_SESSION[$key]);
    }
    
    /**
     * Check if a parameter name exists in the request
     *
     * @param string $name
     * @return boolean
     */
    function exists($key)
    {
        return (isset($_SESSION[$key]));
    }
    
    /**
     * Return the session id name
     *
     * @return string
     */
    function getName() 
    {
        return session_name();
    }
    
    /**
     * Return the session id value
     * 
     * @return string
     */
    function getId() 
    {
        return session_id();
    }
    
}
?>