<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * This object is the base for all Dk objects
 * 
 * Note: This object cannot have a constructor as it locks in the 
 * permission of public,private,protected.
 * 
 * @package Dk
 */
class Dk_Object extends stdClass
{
    
    /**
     * @var integer
     */
    protected $id = '';
    
    
    
    /**
     * Return this object's unique ID
     * 
     * @return string
     */
    function getId()
    {
        
        return $this->id;
    } 
    

    /**
     * Try to validate an object if validator object available
     *
     * @return Dk_Util_Validator
     */
    function validate()
    {
      	$class = get_class($this) . 'Validator';
      	if (class_exists($class)) {
              return new $class($this);
      	}
    }
    
    
    
    
    /**
     * Return a string representation of this object
     *
     * @return string
     */
    function __toString()
    {
        if (method_exists($this, 'toString')) {
            return $this->toString();
        }
        $str = print_r($this, true);
        return $str;
    }
    
}
?>