<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A basic example of an object factory.
 * 
 * <code>
 * <?php
 *    Dk_Mapper_ObjectFactory::getInstance()->getDb();
 * ?>
 * </code>
 *
 * @package Dk
 */
class Dk_Mapper_ObjectFactory 
{
    
    /**
     * @var Dk_Mapper_ObjectFactory
     */
    static protected $instance = null;
    /**
     * @var array
     */
    static private $mappers = array();
    
    
    
    /**
     * This is a constructor
     * If no request session or response parameters given the default Dk objects are used.
     * 
     */
    protected function __construct() { }
    
    /**
     * Get an instance of the object factory
     * 
     * @return Dk_Mapper_ObjectFactory
     */
    static function getInstance() 
    {
        if (self::$instance == null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    
    
    /**
     * Get a database object
     *
     * @return Dk_Db_MyDao
     */
    static function getMapper($class) 
    {
        return self::getInstance()->makeMapper($class);
    }
    
    /**
     * Looks for a mapper class $class . 'Mapper' or you could use the full mapper classname 'Ext_Util_ObjectMapper'
     * 
     * @param string
     * @return Dk_Mapper_Object
     */
    static function makeMapper($class)
    {
        if (is_array($class) && count($class) > 0) {
            $obj = current($class);
            $class = get_class($obj);
        } else if ($class instanceof Dk_Db_Array) {
            $obj = $class->getFirst();
            $class = get_class($obj);
        } else if (is_object($class)) {
            $class = get_class($class);
        } 
        
        
        if (substr($class, -6) != 'Mapper') {
            $class = $class . 'Mapper';
        }
        if (!array_key_exists($class, self::$mappers)) {
            if (!class_exists($class)) {
                throw new Dk_ExceptionSql("Could not find mapper for class `$class'.");
            }
            self::$mappers[$class] = new $class();
        }
        return self::$mappers[$class];
    }
}
?>