<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */



/**
 * The base mapper object that controls the mapping of columns to objects
 *
 * @package Db
 */
abstract class Dk_Mapper_Object extends Dk_Object 
{
    
    /**
     * @var Dk_Mapper_DataMap
     */
    protected $dataMap = null;

    /**
     * @var string
     */
    private $class = '';

    
    
    /**
     *  __construct
     * 
     * @param array $params
     */
    function __construct($params = array())
    {
        $this->params = $params;
        $this->class = substr(get_class($this), 0, -6);
        $this->loadDataMap();
    }
    
    /**
     * A basic fix for compatability with old mapper
     * 
     * @param string $class
     * @return Dk_Db_Mapper
     * @deprecated Will be removed in Ver 2.0 use Dk_Db_ObjectFactory
     */
    static function makeMapper($class)
    {
        return Dk_Db_ObjectFactory::getDbMapper($class);
    }
    
    
    /**
     * Get the mapper datamap
     *
     * @return Dk_Mapper_DataMap
     */
    function getDataMap()
    {
        return $this->dataMap;
    }
    
    /**
     * This is to be implemented in the table mapper object.
     * All columns and other details ae loaded there
     *
     */
    abstract function loadDataMap();
    
    
    /**
     * Load the column maps into another map.
     * 
     * @return array 
     */
    function getColumnMaps()
    {
        return array_merge($this->dataMap->getColumns(), $this->dataMap->getIdColumns());
    }
    
    /**
     * Create an object from and list of parameters
     *
     * @param array $row
     * @return mixed
     */
    function loadArray($row)
    {
        return Dk_Mapper_ObjectLoader::getInstance()->doLoad($row, $this);
    }

    
    
    /**
     * Get the class name that this mapper belongs to
     *
     * @return string
     */
    function getClass()
    {
        return $this->class;
    }
    
    /**
     * Returns a parameter from the dataMap in the params array.
     *
     * @param string $name
     * @return mixed
     */
    function getParameter($name)
    {
        return $this->getDataMap()->getParameter($name);
    }
    
}
?>