<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */
require_once(dirname(__FILE__) . '/../Other/htmlMimeMail5/htmlMimeMail5.php');

/**
 * The mime message object used for sending attachments and inline images 
 * 
 * 
 * @package Mail
 */
class Dk_Mail_MimeMessage extends Dk_Mail_Message
{
    
    /**
     * @var boolean
     */
    protected $html = true;
    
    /**
     * @var string
     */
    protected $imagesDir = '';
    
    /**
     * @var array
     */
    protected $images = array();
    
    /**
     * @var array
     */
    protected $attachments = array();
    
    /**
     * @var array
     */
    protected $attachmentObjs = array();
    
    
    
    
    /**
     * Set to true if this message is a html/mime message
     *
     * @param boolean $b
     */
    function setHtml($b)
    {
        $this->html = $b;
    }
    
    /**
     * Is this message a html message
     *
     * @return boolean
     */
    function isHtml()
    {
        return $this->html;
    }
    
    /**
     * Set the source location for attaching images
     *
     * @param string $dir
     */
    function setImagesDir($dir)
    {
        $this->imagesDir = $dir;
    }
    
    /**
     * Get the source location for the images dir
     *
     * @return string
     */
    function getImagesDir()
    {
        return $this->imagesDir;
    }
    
    
    /**
     * Attatch an inline image file to the message
     *
     * @param string $file 
     * @param string $mimeType 
     */
    function addInlineImage($file, $mimeType)
    {
        $this->images[$file] = $mimeType;
    }
    
    /**
     * Get the map of inline image paths and mime types
     *
     * @return array
     */
    function getInlineImages()
    {
        return $this->images;
    }
    
    /**
     * Add an attachment to this message
     * 
     * @param string $file 
     */
    function addAttachment($file, $mimeType)
    {
        $this->attachments[$file] = $mimeType;
    }
    
    /**
     * Get an array of all attached files
     *
     * @return array
     */
    function getAttachments()
    {
        return $this->attachments;
    }
    
    /**
     * Add an attachment obj to this message
     * 
     * use the object in the htmlMimeMail5 objects
     * 
     * @param attachment $file 
     */
    function addAttachmentObjs($attachment)
    {
        $this->attachmentObjs[] = $attachment;
    }
    
    /**
     * Get an array of all attached objects
     *
     * @return array
     */
    function getAttachmentObjs()
    {
        return $this->attachmentObjs;
    }
    
    
    /**
     * Return a string representation of this message
     *
     * @return string
     */
    function toString() 
    {
        $str = '';
        $str .= 'inline images: ' . count($this->images) . "\n";
        $str .= 'attatchments: ' . count($this->attachments) . "\n";
        $str .= 'isHtml: ' . $this->html ? 'Yes' : 'No' . "\n";
        $str .= 'imagesDir: ' . $this->imagesDir . "\n";
        $str .= parent::toString();
        return $str;
    }
    
}
?>