<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Dk_Mail_Message
 * 
 * 
 * 
 * @package Mail
 */
class Dk_Mail_Message extends Dk_Object
{
    /**
     * @var array
     */
    protected $addressList = array();
    
    /**
     * @var string
     */
    protected $subject = '{No Subject}';
    
    /**
     * @var string
     */
    protected $body = '';
    
    
    /**
     * __construct
     *
     * @param array $addressList
     */
    function __construct($addressList)
    {
        $this->setAddressList($addressList);
    }
    
    
    
    /**
     * Set the array of Dk_Mail_Address objects to use
     * Alternativly you can send a single Dk_Mail_Address object
     *
     * @param mixed $list
     */
    function setAddressList($list)
    {
        if ($list instanceof Dk_Mail_Address) {
            $list = array($list);
        }
        if (!is_array($list)) {
            throw new Dk_ExceptionIllegalArgument('Address list is not of type \'array\'.');
        }
        $this->addressList = $list;
    }
    
    /**
     * Get the message address List
     *
     * @return array
     */
    function getAddressList()
    {
        return $this->addressList;
    }
    
    
    /**
     * Returns the message body.
     *
     * @return string
     */
    function getBody()
    {    
        return $this->body; 
    }
    
    /**
     * The message text body
     *
     * @param string $body
     */
    function setBody($body)
    {
        $this->body = $body;
    }
    
    /**
     * Set the subject
     *
     * @param string $subject
     */
    function setSubject($subject) 
    {
        $this->subject = $subject;
    }
    
    /**
     * Returns the message subject.
     * 
     * @return string
     */
    function getSubject()
    {
        return $this->subject;
    }
    
    /**
     * Send this message to its recipients.
     * 
     * @return boolean True if all emails are sent successfuly false if there are any errors
     */
    function send()
    {
        return Dk_Mail_Gateway::send($this);
    }
    
    
    /**
     * Return a string representation of this message
     *
     * @return string
     */
    function toString() 
    {
        $str  = "\n";
        $str .= 'subject: ' . $this->getSubject() . "\n";
        $str .= "body:  \n-----\n" . $this->getBody() . "\n-----\n";
        return $str;
    }
    
}
?>